/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.data.generator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.OriginsPowerTypes;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.edwinmindcraft.apoli.api.configuration.DoubleComparisonConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.IntegerComparisonConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.ListConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.NoConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.PowerReference;
import io.github.edwinmindcraft.apoli.api.configuration.TagConfiguration;
import io.github.edwinmindcraft.apoli.api.generator.PowerGenerator;
import io.github.edwinmindcraft.apoli.api.power.ConditionData;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.PowerData;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.action.block.DelegatedBlockAction;
import io.github.edwinmindcraft.apoli.common.action.block.SetBlockAction;
import io.github.edwinmindcraft.apoli.common.action.configuration.BlockConfiguration;
import io.github.edwinmindcraft.apoli.common.action.entity.BlockActionAtAction;
import io.github.edwinmindcraft.apoli.common.action.entity.IntegerEntityAction;
import io.github.edwinmindcraft.apoli.common.action.meta.IfElseConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.block.InTagBlockCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.SimpleBlockCondition;
import io.github.edwinmindcraft.apoli.common.condition.configuration.EnchantmentConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.configuration.FluidTagComparisonConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.configuration.InBlockAnywhereConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.entity.EnchantmentCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.FluidHeightCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.InBlockAnywhereCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.PowerActiveCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.SimpleEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.SingleFieldEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.SubmergedInCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.DelegatedItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.IngredientCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.SimpleItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.power.ActionOnItemUsePower;
import io.github.edwinmindcraft.apoli.common.power.BurnPower;
import io.github.edwinmindcraft.apoli.common.power.ClimbingPower;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.apoli.common.power.EntityGlowPower;
import io.github.edwinmindcraft.apoli.common.power.EntityGroupPower;
import io.github.edwinmindcraft.apoli.common.power.ModelColorPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyDamageDealtPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValueBlockPower;
import io.github.edwinmindcraft.apoli.common.power.MultiplePower;
import io.github.edwinmindcraft.apoli.common.power.NightVisionPower;
import io.github.edwinmindcraft.apoli.common.power.PreventBlockActionPower;
import io.github.edwinmindcraft.apoli.common.power.PreventItemActionPower;
import io.github.edwinmindcraft.apoli.common.power.RecipePower;
import io.github.edwinmindcraft.apoli.common.power.TargetCombatActionPower;
import io.github.edwinmindcraft.apoli.common.power.ToggleNightVisionPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ActionOnItemUseConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.BurnConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ClimbingConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ColorConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ConditionedCombatActionConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.EntityGlowConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyDamageDealtConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyValueBlockConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.MultipleConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ToggleNightVisionConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.registry.action.ApoliBlockActions;
import io.github.edwinmindcraft.apoli.common.registry.action.ApoliEntityActions;
import io.github.edwinmindcraft.apoli.common.registry.condition.ApoliBlockConditions;
import io.github.edwinmindcraft.apoli.common.registry.condition.ApoliEntityConditions;
import io.github.edwinmindcraft.apoli.common.registry.condition.ApoliItemConditions;
import io.github.edwinmindcraft.origins.common.power.NoSlowdownPower;
import io.github.edwinmindcraft.origins.common.power.WaterVisionPower;
import io.github.edwinmindcraft.origins.common.power.configuration.NoSlowdownConfiguration;
import io.github.edwinmindcraft.origins.common.power.configuration.WaterVisionConfiguration;
import io.github.edwinmindcraft.origins.data.tag.OriginsBlockTags;
import io.github.edwinmindcraft.origins.data.tag.OriginsItemTags;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.ExistingFileHelper;

public class OriginsPowerProvider
extends PowerGenerator {
    public OriginsPowerProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "origins", existingFileHelper);
    }

    private static Map<String, ConfiguredPower<?, ?>> makeAquaAffinity() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"underwater", ((ModifyValueBlockPower)ApoliPowers.MODIFY_BREAK_SPEED.get()).configure(new ModifyValueBlockConfiguration(ListConfiguration.of(new AttributeModifier(UUID.randomUUID(), "Unnamed attribute modifier", 4.0, AttributeModifier.Operation.MULTIPLY_TOTAL)), null), PowerData.builder().addCondition(ApoliEntityConditions.and((ConfiguredEntityCondition)((SubmergedInCondition)ApoliEntityConditions.SUBMERGED_IN.get()).configure(new TagConfiguration(FluidTags.f_13131_)), (ConfiguredEntityCondition)((EnchantmentCondition)ApoliEntityConditions.ENCHANTMENT.get()).configure(new EnchantmentConfiguration(new IntegerComparisonConfiguration(Comparison.EQUAL, 0), Enchantments.f_44971_, EnchantmentConfiguration.Calculation.SUM)))).build()));
        builder.put((Object)"ungrounded", ((ModifyValueBlockPower)ApoliPowers.MODIFY_BREAK_SPEED.get()).configure(new ModifyValueBlockConfiguration(ListConfiguration.of(new AttributeModifier(UUID.randomUUID(), "Unnamed attribute modifier", 4.0, AttributeModifier.Operation.MULTIPLY_TOTAL)), null), PowerData.builder().addCondition(ApoliEntityConditions.and(new ConfiguredEntityCondition[]{(ConfiguredEntityCondition)((FluidHeightCondition)ApoliEntityConditions.FLUID_HEIGHT.get()).configure(new FluidTagComparisonConfiguration(new DoubleComparisonConfiguration(Comparison.GREATER_THAN, 0.0), (Tag<Fluid>)FluidTags.f_13131_)), ((SingleFieldEntityCondition)ApoliEntityConditions.ON_BLOCK.get()).configure(FieldConfiguration.of(Optional.empty()), new ConditionData(true))})).build()));
        return builder.build();
    }

    private static Map<String, ConfiguredPower<?, ?>> makeMasterOfWebs() {
        ConfiguredBlockCondition inCobwebs = (ConfiguredBlockCondition)((InTagBlockCondition)ApoliBlockConditions.IN_TAG.get()).configure(new TagConfiguration<Block>((Tag<Block>)OriginsBlockTags.COBWEBS));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"webbing", ((TargetCombatActionPower)ApoliPowers.TARGET_ACTION_ON_HIT.get()).configure(new ConditionedCombatActionConfiguration(200, new HudRender(true, 5, Origins.identifier("textures/gui/resource_bar.png"), null, false), null, null, (ConfiguredEntityAction<?, ?>)((BlockActionAtAction)ApoliEntityActions.BLOCK_ACTION_AT.get()).configure(FieldConfiguration.of(((DelegatedBlockAction)ApoliBlockActions.IF_ELSE.get()).configure(new IfElseConfiguration((ConfiguredBlockCondition)((SimpleBlockCondition)ApoliBlockConditions.REPLACEABLE.get()).configure(NoConfiguration.INSTANCE), (ConfiguredBlockAction<?, ?>)((SetBlockAction)ApoliBlockActions.SET_BLOCK.get()).configure(new BlockConfiguration((Block)ModBlocks.TEMPORARY_COBWEB.get())), (ConfiguredBlockAction<?, ?>)null, ApoliBlockActions.PREDICATE, ApoliBlockActions.EXECUTOR))))), PowerData.DEFAULT));
        builder.put((Object)"no_slowdown", ((NoSlowdownPower)OriginsPowerTypes.NO_SLOWDOWN.get()).configure(new NoSlowdownConfiguration((Tag<Block>)OriginsBlockTags.COBWEBS), PowerData.DEFAULT));
        builder.put((Object)"climbing", ((ClimbingPower)ApoliPowers.CLIMBING.get()).configure(new ClimbingConfiguration(true, (ConfiguredEntityCondition)((PowerActiveCondition)ApoliEntityConditions.POWER_ACTIVE.get()).configure(new PowerReference(Origins.identifier("master_of_webs_climbing")))), PowerData.builder().addCondition(ApoliEntityConditions.and((ConfiguredEntityCondition)((InBlockAnywhereCondition)ApoliEntityConditions.IN_BLOCK_ANYWHERE.get()).configure(new InBlockAnywhereConfiguration(inCobwebs)), (ConfiguredEntityCondition)((PowerActiveCondition)ApoliEntityConditions.POWER_ACTIVE.get()).configure(new PowerReference(Origins.identifier("climbing_toggle"))))).build()));
        builder.put((Object)"punch_through", ((PreventBlockActionPower)ApoliPowers.PREVENT_BLOCK_SELECTION.get()).configure(FieldConfiguration.of(Optional.of(inCobwebs)), PowerData.builder().addCondition((ConfiguredEntityCondition<?, ?>)((SimpleEntityCondition)ApoliEntityConditions.SNEAKING.get()).configure(NoConfiguration.INSTANCE, new ConditionData(true))).build()));
        builder.put((Object)"sense", ((EntityGlowPower)ApoliPowers.ENTITY_GLOW.get()).configure(new EntityGlowConfiguration(ApoliEntityConditions.and(new ConfiguredEntityCondition[]{(ConfiguredEntityCondition)((InBlockAnywhereCondition)ApoliEntityConditions.IN_BLOCK_ANYWHERE.get()).configure(new InBlockAnywhereConfiguration(inCobwebs)), ((SingleFieldEntityCondition)ApoliEntityConditions.ENTITY_GROUP.get()).configure(FieldConfiguration.of(MobType.f_21642_), new ConditionData(true))})), PowerData.DEFAULT));
        builder.put((Object)"web_crafting", ((RecipePower)ApoliPowers.RECIPE.get()).configure(FieldConfiguration.of(new ShapelessRecipe(Origins.identifier("master_of_webs/web_crafting"), "", Items.f_41863_.m_7968_(), NonNullList.m_122783_((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_}), (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_})}))), PowerData.DEFAULT));
        return builder.build();
    }

    @Override
    protected void populate() {
        PowerData hidden = PowerData.builder().hidden().build();
        ConditionData inverted = new ConditionData(true);
        this.add("like_water", ((DummyPower)OriginsPowerTypes.LIKE_WATER.get()).configure(NoConfiguration.INSTANCE, PowerData.DEFAULT));
        this.add("water_breathing", ((DummyPower)OriginsPowerTypes.WATER_BREATHING.get()).configure(NoConfiguration.INSTANCE, PowerData.DEFAULT));
        this.add("scare_creepers", ((DummyPower)OriginsPowerTypes.SCARE_CREEPERS.get()).configure(NoConfiguration.INSTANCE, PowerData.DEFAULT));
        this.add("water_vision", ((MultiplePower)ApoliPowers.MULTIPLE.get()).configure(new MultipleConfiguration(ImmutableMap.of((Object)"vision", ((WaterVisionPower)OriginsPowerTypes.WATER_VISION.get()).configure(new WaterVisionConfiguration(1.0f), PowerData.builder().addCondition((ConfiguredEntityCondition)((PowerActiveCondition)ApoliEntityConditions.POWER_ACTIVE.get()).configure(new PowerReference(Origins.identifier("water_vision_toggle")))).build()), (Object)"toggle", ((ToggleNightVisionPower)ApoliPowers.TOGGLE_NIGHT_VISION.get()).configure(new ToggleNightVisionConfiguration(true, IActivePower.Key.PRIMARY, 1.0f), PowerData.builder().addCondition((ConfiguredEntityCondition)((SubmergedInCondition)ApoliEntityConditions.SUBMERGED_IN.get()).configure(new TagConfiguration(FluidTags.f_13131_))).build()))), PowerData.DEFAULT));
        this.add("no_cobweb_slowdown", ((NoSlowdownPower)OriginsPowerTypes.NO_SLOWDOWN.get()).configure(new NoSlowdownConfiguration((Tag<Block>)OriginsBlockTags.COBWEBS), hidden));
        this.add("conduit_power_on_land", ((DummyPower)OriginsPowerTypes.CONDUIT_POWER_ON_LAND.get()).configure(NoConfiguration.INSTANCE, hidden));
        this.add("aerial_combatant", ((ModifyDamageDealtPower)ApoliPowers.MODIFY_DAMAGE_DEALT.get()).configure(new ModifyDamageDealtConfiguration(new AttributeModifier("Extra damage while fall flying", 1.0, AttributeModifier.Operation.MULTIPLY_BASE)), PowerData.builder().addCondition((ConfiguredEntityCondition)((SimpleEntityCondition)ApoliEntityConditions.FALL_FLYING.get()).configure(NoConfiguration.INSTANCE)).build()));
        this.add("air_from_potions", ((ActionOnItemUsePower)ApoliPowers.ACTION_ON_ITEM_USE.get()).configure(new ActionOnItemUseConfiguration((ConfiguredItemCondition)((IngredientCondition)ApoliItemConditions.INGREDIENT.get()).configure(FieldConfiguration.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42589_}))), (ConfiguredEntityAction<?, ?>)((IntegerEntityAction)ApoliEntityActions.GAIN_AIR.get()).configure(FieldConfiguration.of(60)), null), hidden));
        this.add("aqua_affinity", ((MultiplePower)ApoliPowers.MULTIPLE.get()).configure(new MultipleConfiguration(OriginsPowerProvider.makeAquaAffinity()), PowerData.DEFAULT));
        this.add("aquatic", ((EntityGroupPower)ApoliPowers.ENTITY_GROUP.get()).configure(FieldConfiguration.of(MobType.f_21644_), hidden));
        this.add("arcane_skin", ((ModelColorPower)ApoliPowers.MODEL_COLOR.get()).configure(new ColorConfiguration(0.5f, 0.5f, 1.0f, 0.7f), PowerData.DEFAULT));
        this.add("arthropod", ((EntityGroupPower)ApoliPowers.ENTITY_GROUP.get()).configure(FieldConfiguration.of(MobType.f_21642_), hidden));
        this.add("burn_in_daylight", ((BurnPower)ApoliPowers.BURN.get()).configure(new BurnConfiguration(20, 6), PowerData.builder().addCondition(ApoliEntityConditions.and(new ConfiguredEntityCondition[]{(ConfiguredEntityCondition)((SimpleEntityCondition)ApoliEntityConditions.EXPOSED_TO_SUN.get()).configure(NoConfiguration.INSTANCE), ((SimpleEntityCondition)ApoliEntityConditions.INVISIBLE.get()).configure(NoConfiguration.INSTANCE, inverted)})).build()));
        this.add("burning_wrath", ((ModifyDamageDealtPower)ApoliPowers.MODIFY_DAMAGE_DEALT.get()).configure(new ModifyDamageDealtConfiguration(new AttributeModifier("Additional damage while on fire", 3.0, AttributeModifier.Operation.ADDITION)), PowerData.builder().addCondition((ConfiguredEntityCondition)((SimpleEntityCondition)ApoliEntityConditions.ON_FIRE.get()).configure(NoConfiguration.INSTANCE)).build()));
        ConfiguredItemCondition<?, ?> carnivore = ApoliItemConditions.and(new ConfiguredItemCondition[]{((DelegatedItemCondition)ApoliItemConditions.OR.get()).configure(ConditionStreamConfiguration.or(ImmutableList.of((Object)((ConfiguredItemCondition)((IngredientCondition)ApoliItemConditions.INGREDIENT.get()).configure(FieldConfiguration.of(Ingredient.m_43911_(OriginsItemTags.MEAT)))), (Object)((ConfiguredItemCondition)((SimpleItemCondition)ApoliItemConditions.MEAT.get()).configure(NoConfiguration.INSTANCE))), ApoliItemConditions.PREDICATE), inverted), (ConfiguredItemCondition)((SimpleItemCondition)ApoliItemConditions.FOOD.get()).configure(NoConfiguration.INSTANCE), ((IngredientCondition)ApoliItemConditions.INGREDIENT.get()).configure(FieldConfiguration.of(Ingredient.m_43911_(OriginsItemTags.IGNORE_DIET)), inverted)});
        this.add("carnivore", ((PreventItemActionPower)ApoliPowers.PREVENT_ITEM_USAGE.get()).configure(FieldConfiguration.of(Optional.of(carnivore)), PowerData.DEFAULT));
        this.add("cat_vision", ((NightVisionPower)ApoliPowers.NIGHT_VISION.get()).configure(FieldConfiguration.of(Float.valueOf(0.4f)), PowerData.builder().addCondition((ConfiguredEntityCondition<?, ?>)((SubmergedInCondition)ApoliEntityConditions.SUBMERGED_IN.get()).configure(new TagConfiguration(FluidTags.f_13131_), inverted)).build()));
    }
}

