/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.network;

import com.google.common.collect.ImmutableMap;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.client.OriginsClientUtils;
import io.github.edwinmindcraft.origins.common.capabilities.OriginContainer;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CSynchronizeOrigin(int entity, Map<ResourceLocation, ResourceLocation> origins, boolean hadAllOrigins) {
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entity());
        buf.m_130130_(this.origins().size());
        this.origins().forEach((layer, origin) -> {
            buf.m_130085_(layer);
            buf.m_130085_(origin);
        });
        buf.writeBoolean(this.hadAllOrigins());
    }

    public static S2CSynchronizeOrigin decode(FriendlyByteBuf buf) {
        int entity = buf.readInt();
        int size = buf.m_130242_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            builder.put((Object)buf.m_130281_(), (Object)buf.m_130281_());
        }
        boolean hadAll = buf.readBoolean();
        return new S2CSynchronizeOrigin(entity, (Map<ResourceLocation, ResourceLocation>)builder.build(), hadAll);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Level level = (Level)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> OriginsClientUtils::getClientLevel);
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(this.entity());
            if (entity == null) {
                return;
            }
            entity.getCapability(OriginsAPI.ORIGIN_CONTAINER).ifPresent(x -> {
                if (x instanceof OriginContainer) {
                    OriginContainer container = (OriginContainer)x;
                    container.acceptSynchronization(this.origins(), this.hadAllOrigins());
                }
            });
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

