/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.network;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.screen.Badge;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public record S2CSynchronizeBadges(Multimap<ResourceLocation, Badge> badges) {
    public static S2CSynchronizeBadges decode(FriendlyByteBuf buf) {
        HashMultimap badges = HashMultimap.create();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation rl = buf.m_130281_();
            int count = buf.m_130242_();
            for (int j = 0; j < count; ++j) {
                badges.put((Object)rl, (Object)Badge.fromNetwork(buf));
            }
        }
        return new S2CSynchronizeBadges((Multimap<ResourceLocation, Badge>)badges);
    }

    public void encode(FriendlyByteBuf buf) {
        Map map = this.badges().asMap();
        buf.m_130130_(map.size());
        for (Map.Entry entry : map.entrySet()) {
            buf.m_130085_((ResourceLocation)entry.getKey());
            buf.m_130130_(((Collection)entry.getValue()).size());
            for (Badge badge : (Collection)entry.getValue()) {
                badge.toNetwork(buf);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Origins.badgeManager.clear();
            this.badges.forEach(Origins.badgeManager::addBadge);
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

