/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.network;

import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.client.OriginsClientUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CConfirmOrigin(ResourceLocation layer, ResourceLocation origin) {
    public static S2CConfirmOrigin decode(FriendlyByteBuf buf) {
        return new S2CConfirmOrigin(buf.m_130281_(), buf.m_130281_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.layer());
        buf.m_130085_(this.origin());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Player player = (Player)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> OriginsClientUtils::getClientPlayer);
            if (player == null) {
                return;
            }
            IOriginContainer.get((Entity)player).ifPresent(x -> x.setOrigin((OriginLayer)OriginsAPI.getLayersRegistry().m_7745_(this.layer()), (Origin)((Object)((Object)((Object)OriginsAPI.getOriginsRegistry().m_7745_(this.origin()))))));
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                if (Minecraft.m_91087_().f_91080_ instanceof WaitForNextLayerScreen) {
                    ((WaitForNextLayerScreen)Minecraft.m_91087_().f_91080_).openSelection();
                }
            });
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

