/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.origin;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.ConditionedOrigin;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record OriginLayer(int order, ResourceLocation registryName, Set<ConditionedOrigin> conditionedOrigins, boolean enabled, Component name, Component missingName, Component missingDescription, boolean allowRandom, boolean allowRandomUnchoosable, Set<ResourceLocation> randomExclusions, @Nullable ResourceLocation defaultOrigin, boolean autoChoose, boolean hidden) implements Comparable<OriginLayer>
{
    public static final Codec<OriginLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("order").forGetter(OriginLayer::order), (App)ResourceLocation.f_135803_.fieldOf("registry_name").forGetter(OriginLayer::registryName), (App)CalioCodecHelper.setOf(ConditionedOrigin.CODEC).fieldOf("origins").forGetter(OriginLayer::conditionedOrigins), (App)Codec.BOOL.fieldOf("enabled").forGetter(OriginLayer::enabled), (App)CalioCodecHelper.COMPONENT_CODEC.fieldOf("name").forGetter(OriginLayer::name), (App)CalioCodecHelper.COMPONENT_CODEC.fieldOf("missing_name").forGetter(OriginLayer::missingName), (App)CalioCodecHelper.COMPONENT_CODEC.fieldOf("missing_description").forGetter(OriginLayer::missingDescription), (App)Codec.BOOL.fieldOf("allow_random").forGetter(OriginLayer::allowRandom), (App)Codec.BOOL.fieldOf("allow_random_unchoosable").forGetter(OriginLayer::allowRandomUnchoosable), (App)CalioCodecHelper.setOf(ResourceLocation.f_135803_).fieldOf("random_exclusions").forGetter(OriginLayer::randomExclusions), (App)CalioCodecHelper.optionalField(ResourceLocation.f_135803_, "default").forGetter(x -> Optional.ofNullable(x.defaultOrigin())), (App)Codec.BOOL.fieldOf("auto_choose").forGetter(OriginLayer::autoChoose), (App)CalioCodecHelper.optionalField(Codec.BOOL, "hidden", false).forGetter(OriginLayer::hidden)).apply((Applicative)instance, (order1, registryName1, conditionedOrigins1, enabled1, name1, missingName1, missingDescription1, allowRandom1, allowRandomUnchoosable1, randomExclusions1, defaultOrigin1, autoChoose1, hidden) -> new OriginLayer((int)order1, (ResourceLocation)registryName1, (Set<ConditionedOrigin>)conditionedOrigins1, (boolean)enabled1, (Component)name1, (Component)missingName1, (Component)missingDescription1, (boolean)allowRandom1, (boolean)allowRandomUnchoosable1, (Set<ResourceLocation>)randomExclusions1, defaultOrigin1.orElse(null), (boolean)autoChoose1, (boolean)hidden)));

    public OriginLayer cleanup(ICalioDynamicRegistryManager registries) {
        WritableRegistry<Origin> registry = registries.get(OriginsDynamicRegistries.ORIGINS_REGISTRY);
        return new OriginLayer(this.order(), this.registryName(), (Set)this.conditionedOrigins().stream().map(x -> x.cleanup(registries)).filter(x -> !x.isEmpty()).collect(ImmutableSet.toImmutableSet()), this.enabled(), this.name(), this.missingName(), this.missingDescription(), this.allowRandom(), this.allowRandomUnchoosable(), (Set)this.randomExclusions().stream().filter(arg_0 -> registry.m_7804_(arg_0)).collect(ImmutableSet.toImmutableSet()), this.defaultOrigin(), this.autoChoose(), this.hidden());
    }

    public boolean hasDefaultOrigin() {
        return this.defaultOrigin() != null;
    }

    public Set<ResourceLocation> origins() {
        return this.conditionedOrigins().stream().flatMap(ConditionedOrigin::stream).collect(Collectors.toSet());
    }

    public Set<ResourceLocation> origins(Player player) {
        return this.conditionedOrigins().stream().flatMap(x -> x.stream(player)).collect(Collectors.toSet());
    }

    public List<ResourceLocation> randomOrigins(Player player) {
        Registry<Origin> origins = OriginsAPI.getOriginsRegistry();
        return this.conditionedOrigins().stream().flatMap(x -> x.stream(player)).filter(o -> !this.randomExclusions().contains(o)).filter(id -> origins.m_6612_(id).map(x -> this.allowRandomUnchoosable() || x.isChoosable()).orElse(false)).collect(Collectors.toList());
    }

    public boolean contains(ResourceLocation origin) {
        return this.conditionedOrigins().stream().anyMatch(x -> x.origins().contains(origin));
    }

    public boolean contains(ResourceLocation origin, Player player) {
        return this.conditionedOrigins().stream().anyMatch(x -> ConfiguredEntityCondition.check(x.condition(), (Entity)player) && x.origins().contains(origin));
    }

    @NotNull
    public Optional<Origin> getAutomaticOrigin(Player player) {
        if (!this.autoChoose()) {
            return Optional.empty();
        }
        Registry<Origin> registry = OriginsAPI.getOriginsRegistry();
        List origins = this.origins(player).stream().flatMap(x -> registry.m_6612_(x).stream().filter(Origin::isChoosable)).toList();
        if (this.allowRandom() && origins.isEmpty()) {
            return this.selectRandom(player);
        }
        if (origins.size() > 1) {
            return Optional.empty();
        }
        return origins.stream().findFirst();
    }

    public Optional<Origin> selectRandom(Player player) {
        if (!this.allowRandom()) {
            return Optional.empty();
        }
        Registry<Origin> origins = OriginsAPI.getOriginsRegistry();
        List<Origin> candidates = this.conditionedOrigins.stream().flatMap(x -> x.stream(player)).flatMap(x -> origins.m_6612_(x).stream()).filter(x -> this.allowRandomUnchoosable() || x.isChoosable()).toList();
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        if (candidates.size() == 1) {
            return Optional.of(candidates.get(0));
        }
        return Optional.of(candidates.get(player.m_21187_().nextInt(candidates.size())));
    }

    public int getOriginOptionCount(Player playerEntity) {
        Registry<Origin> origins = OriginsAPI.getOriginsRegistry();
        long choosableOrigins = this.origins(playerEntity).stream().flatMap(x -> origins.m_6612_(x).stream()).filter(Origin::isChoosable).count();
        if (this.allowRandom() && this.randomOrigins(playerEntity).size() > 0) {
            ++choosableOrigins;
        }
        return Math.toIntExact(choosableOrigins);
    }

    @Override
    public int compareTo(@NotNull OriginLayer o) {
        return Integer.compare(this.order(), o.order());
    }
}

