/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.origin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record ConditionedOrigin(@Nullable ConfiguredEntityCondition<?, ?> condition, Set<ResourceLocation> origins) {
    public static final Codec<ConditionedOrigin> LARGE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField(ConfiguredEntityCondition.CODEC, "condition").forGetter(x -> Optional.ofNullable(x.condition())), (App)SerializableDataTypes.IDENTIFIERS.fieldOf("origins").forGetter(x -> ImmutableList.copyOf(x.origins()))).apply((Applicative)instance, (condition, origins) -> new ConditionedOrigin(condition.orElse(null), (Set<ResourceLocation>)ImmutableSet.copyOf((Collection)origins))));
    public static final Codec<ConditionedOrigin> STRING_CODEC = Codec.STRING.flatComapMap(s -> {
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)s);
        return new ConditionedOrigin(null, (Set<ResourceLocation>)(resourceLocation != null ? ImmutableSet.of((Object)resourceLocation) : ImmutableSet.of()));
    }, co -> {
        if (co.origins().size() != 1) {
            return DataResult.error((String)("Invalid size: " + co.origins().size()));
        }
        return co.origins().stream().findFirst().map(ResourceLocation::toString).map(DataResult::success).orElseGet(() -> DataResult.error((String)"Unknown Error"));
    });
    public static final Codec<ConditionedOrigin> CODEC = Codec.either(STRING_CODEC, LARGE_CODEC).xmap(e -> (ConditionedOrigin)e.map(Function.identity(), Function.identity()), co -> co.origins().size() == 1 && co.condition() == null ? Either.left((Object)co) : Either.right((Object)co));

    public Stream<ResourceLocation> stream(Player player) {
        return ConfiguredEntityCondition.check(this.condition(), (Entity)player) ? this.origins().stream() : Stream.empty();
    }

    public Stream<ResourceLocation> stream() {
        return this.origins().stream();
    }

    public boolean isEmpty() {
        return this.origins().isEmpty();
    }

    public ConditionedOrigin cleanup(ICalioDynamicRegistryManager registries) {
        WritableRegistry<Origin> registry = registries.get(OriginsDynamicRegistries.ORIGINS_REGISTRY);
        return new ConditionedOrigin(this.condition(), (Set)this.origins().stream().filter(arg_0 -> registry.m_7804_(arg_0)).collect(ImmutableSet.toImmutableSet()));
    }

    public static enum Serializer implements JsonSerializer<ConditionedOrigin>,
    JsonDeserializer<ConditionedOrigin>
    {
        INSTANCE;


        public ConditionedOrigin deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            DataResult result = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            return (ConditionedOrigin)((Pair)result.getOrThrow(false, s -> {
                throw new JsonParseException("Expected origin in layer to be either a string or an object.");
            })).getFirst();
        }

        public JsonElement serialize(ConditionedOrigin src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.isEmpty()) {
                return new JsonPrimitive("<empty conditioned origin>");
            }
            return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)src).getOrThrow(false, s -> {});
        }
    }
}

