/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.data;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.data.CompatibilityDataTypes;
import io.github.apace100.origins.origin.Impact;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginUpgrade;
import io.github.edwinmindcraft.origins.api.util.JsonUtils;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PartialOrigin(@NotNull Set<ResourceLocation> powers, @Nullable ItemStack icon, @Nullable Boolean unchoosable, @Nullable Integer order, @Nullable Impact impact, @Nullable String name, @Nullable String description, @NotNull Set<OriginUpgrade> upgrades, int loadingOrder) {
    public Origin create(ResourceLocation name) {
        return new Origin((Set<ResourceLocation>)ImmutableSet.copyOf(this.powers()), this.icon() != null ? this.icon() : ItemStack.f_41583_, this.unchoosable() != null ? this.unchoosable() : false, this.order() != null ? this.order() : Integer.MAX_VALUE, this.impact() != null ? this.impact() : Impact.NONE, (Component)new TranslatableComponent((String)(this.name() != null ? this.name() : "origin." + name.m_135827_() + "." + name.m_135815_() + ".name")), (Component)new TranslatableComponent((String)(this.description() != null ? this.description() : "origin." + name.m_135827_() + "." + name.m_135815_() + ".description")), (Set<OriginUpgrade>)ImmutableSet.copyOf(this.upgrades()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableSet.Builder<ResourceLocation> powers = ImmutableSet.builder();
        private final ImmutableSet.Builder<OriginUpgrade> upgrades = ImmutableSet.builder();
        private ItemStack icon;
        private Boolean unchoosable;
        private Integer order;
        private Impact impact;
        private String name;
        private String description;
        private int loadingOrder = 0;

        private Builder() {
        }

        public Builder powers(Iterable<ResourceLocation> powers) {
            Origins.LOGGER.info("Found powers [{}]", (Object)String.join((CharSequence)",", Streams.stream(powers).map(ResourceLocation::toString).collect(Collectors.toSet())));
            this.powers.addAll(powers);
            return this;
        }

        public Builder powers(ResourceLocation ... powers) {
            this.powers.add((Object[])powers);
            return this;
        }

        public Builder icon(ItemStack icon) {
            this.icon = icon;
            return this;
        }

        public Builder unchoosable(Boolean unchoosable) {
            this.unchoosable = unchoosable;
            return this;
        }

        public Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public Builder impact(Impact impact) {
            this.impact = impact;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder upgrades(Iterable<OriginUpgrade> upgrades) {
            this.upgrades.addAll(upgrades);
            return this;
        }

        public Builder upgrades(OriginUpgrade ... upgrades) {
            this.upgrades.add((Object[])upgrades);
            return this;
        }

        public Builder loadingOrder(int loadingOrder) {
            this.loadingOrder = loadingOrder;
            return this;
        }

        public PartialOrigin build() {
            return new PartialOrigin((Set<ResourceLocation>)this.powers.build(), this.icon, this.unchoosable, this.order, this.impact, this.name, this.description, (Set<OriginUpgrade>)this.upgrades.build(), this.loadingOrder);
        }
    }

    public static enum Serializer implements JsonSerializer<PartialOrigin>,
    JsonDeserializer<PartialOrigin>
    {
        INSTANCE;


        public PartialOrigin deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement icon;
            ItemStack read;
            JsonObject root = GsonHelper.m_13918_((JsonElement)json, (String)"root element");
            Builder builder = PartialOrigin.builder();
            builder.powers(JsonUtils.getIdentifierList(root, "powers"));
            if (root.has("icon") && (read = CompatibilityDataTypes.ITEM_OR_ITEM_STACK.read(icon = root.get("icon"))) != null) {
                builder.icon(read);
            }
            JsonUtils.getOptional(root, "unchoosable", GsonHelper::m_13912_).ifPresent(builder::unchoosable);
            JsonUtils.getOptional(root, "order", GsonHelper::m_13927_).ifPresent(builder::order);
            JsonUtils.getOptional(root, "impact", GsonHelper::m_13927_).ifPresent(x -> {
                if (x < 0 || x >= Impact.values().length) {
                    throw new JsonParseException("Impact must be between 0 and " + (Impact.values().length - 1) + ", was " + x);
                }
                builder.impact(Impact.values()[x]);
            });
            JsonUtils.getOptional(root, "name", GsonHelper::m_13906_).ifPresent(builder::name);
            JsonUtils.getOptional(root, "description", GsonHelper::m_13906_).ifPresent(builder::description);
            builder.upgrades(JsonUtils.getOptionalList(root, "upgrades", (x, s) -> (OriginUpgrade)context.deserialize(x, OriginUpgrade.class)));
            JsonUtils.getOptional(root, "loading_priority", GsonHelper::m_13927_).ifPresent(builder::loadingOrder);
            return builder.build();
        }

        public JsonElement serialize(PartialOrigin src, Type typeOfSrc, JsonSerializationContext context) {
            return null;
        }
    }
}

