/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class PropagatingOptionalFieldCodec<A>
extends MapCodec<Optional<A>> {
    private final String name;
    private final Codec<A> elementCodec;

    public PropagatingOptionalFieldCodec(String name, Codec<A> elementCodec) {
        this.name = name;
        this.elementCodec = elementCodec;
    }

    public <T> DataResult<Optional<A>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.success(Optional.empty());
        }
        return this.elementCodec.parse(ops, value).map(Optional::of);
    }

    public <T> RecordBuilder<T> encode(Optional<A> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        if (input.isPresent()) {
            return prefix.add(this.name, this.elementCodec.encodeStart(ops, input.get()));
        }
        return prefix;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PropagatingOptionalFieldCodec that = (PropagatingOptionalFieldCodec)((Object)o);
        return Objects.equals(this.name, that.name) && Objects.equals(this.elementCodec, that.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.elementCodec);
    }

    public String toString() {
        return "PropagatingOptionalFieldCodec[" + this.name + ": " + this.elementCodec + "]";
    }
}

