/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class PropagatingDefaultedOptionalFieldCodec<A>
extends MapCodec<A> {
    private final String name;
    private final Codec<A> elementCodec;
    private final Supplier<A> defaultValue;

    public PropagatingDefaultedOptionalFieldCodec(String name, Codec<A> elementCodec, Supplier<A> defaultValue) {
        this.name = name;
        this.elementCodec = elementCodec;
        this.defaultValue = defaultValue;
    }

    public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.success(this.defaultValue.get());
        }
        return this.elementCodec.parse(ops, value);
    }

    public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        if (!Objects.equals(this.defaultValue.get(), input)) {
            return prefix.add(this.name, this.elementCodec.encodeStart(ops, input));
        }
        return prefix;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PropagatingDefaultedOptionalFieldCodec that = (PropagatingDefaultedOptionalFieldCodec)((Object)o);
        return Objects.equals(this.name, that.name) && Objects.equals(this.elementCodec, that.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.elementCodec);
    }

    public String toString() {
        return "PropagatingDefaultedOptionalFieldCodec[" + this.name + ": " + this.elementCodec + "]";
    }
}

