/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumValueCodec<A extends Enum<A>>
implements Codec<A> {
    private final A[] values;
    private final Multimap<A, String> names;
    private final Map<String, A> fields;

    public EnumValueCodec(A[] values, @Nullable Map<String, A> names) {
        this.values = values;
        ImmutableSetMultimap.Builder namesBuilder = ImmutableSetMultimap.builder();
        HashMap<String, A> fieldsBuilder = new HashMap<String, A>();
        for (Object value : values) {
            String name = ((Enum)value).name().toLowerCase(Locale.ROOT);
            namesBuilder.put(value, (Object)name);
            fieldsBuilder.put(name, value);
        }
        if (names != null) {
            for (Map.Entry entry : names.entrySet()) {
                Object value;
                String name = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                value = (Enum)entry.getValue();
                if (fieldsBuilder.containsKey(name) && fieldsBuilder.get(name) != value) {
                    throw new IllegalArgumentException("Name " + name + " was valid for values \"" + fieldsBuilder.get(name) + "\" and \"" + value + "\". This is unsupported");
                }
                fieldsBuilder.put(name, value);
                namesBuilder.put(value, (Object)name);
            }
        }
        this.names = namesBuilder.build();
        this.fields = ImmutableMap.copyOf(fieldsBuilder);
    }

    @NotNull
    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        DataResult intValue = ops.getNumberValue(input).map(Number::intValue);
        if (intValue.error().isPresent()) {
            DataResult stringValue = ops.getStringValue(input);
            if (stringValue.error().isPresent()) {
                return DataResult.error((String)("Errors reading " + this.values.getClass().getComponentType().getSimpleName() + ": I:" + intValue.error().get() + " S:" + stringValue.error().get()));
            }
            String key = ((String)stringValue.result().get()).toLowerCase(Locale.ROOT);
            Enum value = (Enum)this.fields.get(key);
            if (value == null) {
                return DataResult.error((String)("Error reading " + this.values.getClass().getComponentType().getSimpleName() + ": No value was found for name: \"" + key + "\""));
            }
            return DataResult.success((Object)Pair.of((Object)value, (Object)ops.empty()));
        }
        int integer = (Integer)intValue.result().get();
        if (integer < 0 || integer >= this.values.length) {
            return DataResult.error((String)("Error reading " + this.values.getClass().getComponentType().getSimpleName() + ": Value " + integer + " was out of range: [0," + (this.values.length - 1) + "]"));
        }
        return DataResult.success((Object)Pair.of(this.values[integer], (Object)ops.empty()));
    }

    public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        if (!CalioCodecHelper.isDataContext(ops)) {
            return DataResult.success((Object)ops.createInt(((Enum)input).ordinal()));
        }
        Collection names = this.names.get(input);
        if (names.isEmpty()) {
            return DataResult.success((Object)ops.createInt(((Enum)input).ordinal()));
        }
        String name = names.stream().min(Comparator.comparingInt(String::length)).orElseThrow();
        return DataResult.success((Object)ops.createString(name));
    }
}

