/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.FilterableWeightedList;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.calio.api.network.IContextAwareCodec;
import io.github.edwinmindcraft.calio.api.network.PropagatingDefaultedOptionalFieldCodec;
import io.github.edwinmindcraft.calio.api.network.PropagatingOptionalFieldCodec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class CalioCodecHelper {
    public static final Codec<Component> COMPONENT_CODEC = new IContextAwareCodec<Component>(){

        @Override
        public JsonElement asJson(Component input) {
            return Component.Serializer.m_130716_((Component)input);
        }

        @Override
        public Component fromJson(JsonElement input) {
            return Component.Serializer.m_130691_((JsonElement)input);
        }

        @Override
        public void encode(Component input, FriendlyByteBuf buf) {
            buf.m_130083_(input);
        }

        @Override
        public Component decode(FriendlyByteBuf buf) {
            return buf.m_130238_();
        }
    };
    public static MapCodec<Vec3> VEC3D = CalioCodecHelper.vec3d("x", "y", "z");
    public static MapCodec<Vector3f> VEC3F = CalioCodecHelper.vec3f("x", "y", "z");
    public static MapCodec<BlockPos> BLOCK_POS = CalioCodecHelper.blockPos("x", "y", "z");

    public static <T> Codec<ResourceKey<T>> resourceKey(ResourceKey<? extends Registry<T>> registry) {
        return SerializableDataTypes.IDENTIFIER.xmap(x -> ResourceKey.m_135785_((ResourceKey)registry, (ResourceLocation)x), ResourceKey::m_135782_);
    }

    public static <T> Codec<FilterableWeightedList<T>> weightedListOf(Codec<T> source) {
        return RecordCodecBuilder.create(instance -> instance.group((App)source.fieldOf("element").forGetter(Pair::getFirst), (App)Codec.INT.fieldOf("weight").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf().xmap(pairs -> {
            FilterableWeightedList list = new FilterableWeightedList();
            pairs.forEach(pair -> list.m_147929_(pair.getFirst(), (Integer)pair.getSecond()));
            return list;
        }, list -> list.entryStream().map(x -> Pair.of((Object)x.m_147940_(), (Object)x.m_147945_())).toList());
    }

    public static <T> Codec<List<T>> listOf(Codec<T> source) {
        return Codec.either(source, (Codec)source.listOf()).xmap(x -> (List)x.map(xva$0 -> Arrays.asList(xva$0), Function.identity()), x -> x.size() == 1 ? Either.left(x.get(0)) : Either.right((Object)x));
    }

    public static <T> Codec<List<T>> optionalListOf(Codec<Optional<T>> source) {
        return CalioCodecHelper.listOf(source).xmap(x -> x.stream().flatMap(Optional::stream).collect(Collectors.toList()), objects -> objects.stream().filter(Objects::nonNull).map(Optional::of).collect(Collectors.toList()));
    }

    public static <T> MapCodec<List<T>> listOf(Codec<T> source, String singular, String plural) {
        Codec listCodec = CalioCodecHelper.listOf(source);
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(listCodec, singular, ImmutableList.of()).forGetter(x -> x.size() == 1 ? x : ImmutableList.of()), (App)CalioCodecHelper.optionalField(listCodec, plural, ImmutableList.of()).forGetter(x -> x.size() == 1 ? ImmutableList.of() : x)).apply((Applicative)instance, (ls1, ls2) -> ImmutableList.builder().addAll((Iterable)ls1).addAll((Iterable)ls2).build()));
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> source) {
        return CalioCodecHelper.listOf(source).xmap(HashSet::new, ArrayList::new);
    }

    public static <A> PropagatingOptionalFieldCodec<A> optionalField(Codec<A> codec, String name) {
        return new PropagatingOptionalFieldCodec<A>(name, codec);
    }

    public static <A> PropagatingDefaultedOptionalFieldCodec<A> optionalField(Codec<A> codec, String name, A defaultValue) {
        return new PropagatingDefaultedOptionalFieldCodec<Object>(name, codec, () -> defaultValue);
    }

    public static <A> PropagatingDefaultedOptionalFieldCodec<A> optionalField(Codec<A> codec, String name, Supplier<A> defaultValue) {
        return new PropagatingDefaultedOptionalFieldCodec<A>(name, codec, defaultValue);
    }

    public static MapCodec<Vec3> vec3d(String xName, String yName, String zName) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(Codec.DOUBLE, xName, 0.0).forGetter(Vec3::m_7096_), (App)CalioCodecHelper.optionalField(Codec.DOUBLE, yName, 0.0).forGetter(Vec3::m_7098_), (App)CalioCodecHelper.optionalField(Codec.DOUBLE, zName, 0.0).forGetter(Vec3::m_7094_)).apply((Applicative)instance, Vec3::new));
    }

    public static MapCodec<Vector3f> vec3f(String xName, String yName, String zName) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(Codec.FLOAT, xName, Float.valueOf(0.0f)).forGetter(Vector3f::m_122239_), (App)CalioCodecHelper.optionalField(Codec.FLOAT, yName, Float.valueOf(0.0f)).forGetter(Vector3f::m_122260_), (App)CalioCodecHelper.optionalField(Codec.FLOAT, zName, Float.valueOf(0.0f)).forGetter(Vector3f::m_122269_)).apply((Applicative)instance, Vector3f::new));
    }

    public static MapCodec<Vec3> vec3d(String prefix) {
        return CalioCodecHelper.vec3d(prefix + "x", prefix + "y", prefix + "z");
    }

    public static MapCodec<BlockPos> blockPos(String xName, String yName, String zName) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(Codec.INT, xName, 0).forGetter(Vec3i::m_123341_), (App)CalioCodecHelper.optionalField(Codec.INT, yName, 0).forGetter(Vec3i::m_123342_), (App)CalioCodecHelper.optionalField(Codec.INT, zName, 0).forGetter(Vec3i::m_123343_)).apply((Applicative)instance, BlockPos::new));
    }

    public static MapCodec<BlockPos> blockPos(String prefix) {
        return CalioCodecHelper.blockPos(prefix + "x", prefix + "y", prefix + "z");
    }

    public static <T> CodecJsonAdapter<T> jsonAdapter(Codec<T> input) {
        return new CodecJsonAdapter<T>(input);
    }

    public static boolean isDataContext(DynamicOps<?> ops) {
        return ops instanceof JsonOps && !ops.compressMaps();
    }

    public static class CodecJsonAdapter<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private final Codec<T> codec;

        private CodecJsonAdapter(Codec<T> codec) {
            this.codec = codec;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (T)((Pair)this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, s -> {
                throw new JsonParseException("Found error: " + s);
            })).getFirst();
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, src).getOrThrow(false, s -> {});
        }
    }
}

