/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.fabric;

import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappingRegistry<T, F extends IForgeRegistryEntry<F>>
extends WritableRegistry<T> {
    private final Lifecycle lifecycle;
    private final Lazy<IForgeRegistry<F>> registry;
    private final Class<F> forgeClass;
    private final Function<T, F> from;
    private final Function<F, T> to;
    private final Map<String, DeferredRegister<F>> registerMap;

    public WrappingRegistry(ResourceKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Supplier<IForgeRegistry<F>> registry, Class<F> forgeClass, Function<T, F> from, Function<F, T> to) {
        super(registryKey, lifecycle);
        this.lifecycle = lifecycle;
        this.registry = Lazy.of(registry);
        this.forgeClass = forgeClass;
        this.from = from;
        this.to = to;
        this.registerMap = new HashMap<String, DeferredRegister<F>>();
    }

    private DeferredRegister<F> createRegister(String modid) {
        DeferredRegister register = DeferredRegister.create(this.forgeClass, (String)modid);
        register.register(FMLJavaModLoadingContext.get().getModEventBus());
        return register;
    }

    public <V extends T> V m_5748_(int id, ResourceKey<T> resourceKey, V value, Lifecycle lifecycle) {
        return this.m_7135_(resourceKey, value, lifecycle);
    }

    public <V extends T> V m_7135_(ResourceKey<T> resourceKey, V value, Lifecycle lifecycle) {
        this.registerMap.computeIfAbsent(resourceKey.m_135782_().m_135827_(), this::createRegister).register(resourceKey.m_135782_().m_135815_(), () -> (IForgeRegistryEntry)this.from.apply(value));
        return value;
    }

    public <V extends T> V m_7794_(OptionalInt id, ResourceKey<T> resourceKey, V value, Lifecycle lifecycle) {
        return this.m_7135_(resourceKey, value, lifecycle);
    }

    public boolean m_142427_() {
        return ((IForgeRegistry)this.registry.get()).isEmpty();
    }

    @Nullable
    public ResourceLocation m_7981_(T object) {
        return ((IForgeRegistry)this.registry.get()).getKey((IForgeRegistryEntry)this.from.apply(object));
    }

    public Optional<ResourceKey<T>> m_7854_(T object) {
        ResourceLocation key = this.m_7981_(object);
        return key == null ? Optional.empty() : Optional.of(ResourceKey.m_135785_((ResourceKey)this.m_123023_(), (ResourceLocation)key));
    }

    public int m_7447_(@Nullable T object) {
        int n;
        Object object2 = this.registry.get();
        if (object2 instanceof ForgeRegistry) {
            ForgeRegistry fr = (ForgeRegistry)object2;
            n = fr.getID((IForgeRegistryEntry)this.from.apply(object));
        } else {
            n = -1;
        }
        return n;
    }

    @Nullable
    public T m_7942_(int id) {
        T t;
        Object object = this.registry.get();
        if (object instanceof ForgeRegistry) {
            ForgeRegistry fr = (ForgeRegistry)object;
            t = this.to.apply(fr.getValue(id));
        } else {
            t = null;
        }
        return t;
    }

    public int m_183450_() {
        return ((IForgeRegistry)this.registry.get()).getKeys().size();
    }

    @Nullable
    public T m_6246_(@Nullable ResourceKey<T> resourceKey) {
        return this.m_7745_(resourceKey == null ? null : resourceKey.m_135782_());
    }

    @Nullable
    public T m_7745_(@Nullable ResourceLocation location) {
        return this.to.apply(((IForgeRegistry)this.registry.get()).getValue(location));
    }

    public Lifecycle m_6228_(T p_123012_) {
        return this.lifecycle;
    }

    public Lifecycle m_7837_() {
        return this.lifecycle;
    }

    public Set<ResourceLocation> m_6566_() {
        return ((IForgeRegistry)this.registry.get()).getKeys();
    }

    public Set<Map.Entry<ResourceKey<T>, T>> m_6579_() {
        return ((IForgeRegistry)this.registry.get()).getEntries().stream().map(x -> Map.entry((ResourceKey)x.getKey(), this.to.apply((IForgeRegistryEntry)x.getValue()))).collect(Collectors.toSet());
    }

    @Nullable
    public T m_142697_(Random random) {
        List values = ((IForgeRegistry)this.registry.get()).getValues().stream().toList();
        return values.isEmpty() ? null : (T)this.to.apply((IForgeRegistryEntry)values.get(random.nextInt(values.size())));
    }

    public boolean m_7804_(ResourceLocation location) {
        return ((IForgeRegistry)this.registry.get()).containsKey(location);
    }

    public boolean m_142003_(ResourceKey<T> resourceKey) {
        return ((IForgeRegistry)this.registry.get()).containsKey(resourceKey.m_135782_());
    }

    @NotNull
    public Iterator<T> iterator() {
        return ((IForgeRegistry)this.registry.get()).getValues().stream().map(this.to).iterator();
    }
}

