/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.util;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.common.power.ElytraFlightPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyHarvestPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValueBlockPower;
import io.github.edwinmindcraft.apoli.common.power.RestrictArmorPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyValueBlockConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class CoreUtils {
    public static boolean isItemForbidden(Entity entity, EquipmentSlot slot, ItemStack stack) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        return RestrictArmorPower.isForbidden((Entity)living, slot, stack) || stack.m_150930_(Items.f_42741_) && IPowerContainer.hasPower((Entity)living, (ElytraFlightPower)ApoliPowers.ELYTRA_FLIGHT.get());
    }

    public static BlockState getInWallBlockState(LivingEntity playerEntity) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d = playerEntity.m_20185_() + (double)(((float)(i % 2) - 0.5f) * playerEntity.m_20205_() * 0.8f);
            double e = playerEntity.m_20188_() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = playerEntity.m_20189_() + (double)(((float)((i >> 2) % 2) - 0.5f) * playerEntity.m_20205_() * 0.8f);
            mutable.m_122169_(d, e, f);
            BlockState blockState = playerEntity.f_19853_.m_8055_((BlockPos)mutable);
            if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60831_((BlockGetter)playerEntity.f_19853_, (BlockPos)mutable)) continue;
            return blockState;
        }
        return null;
    }

    public static float modifyFriction(float friction, LevelReader level, BlockPos pos, @Nullable Entity entity, BlockState state) {
        if (entity != null) {
            return IPowerContainer.modify(entity, (ModifyValueBlockPower)ApoliPowers.MODIFY_SLIPPERINESS.get(), friction, p -> ConfiguredBlockCondition.check(((ModifyValueBlockConfiguration)p.getConfiguration()).condition(), level, pos, (NonNullSupplier<BlockState>)((NonNullSupplier)() -> state)));
        }
        return friction;
    }

    public static int allowHarvest(BlockGetter level, BlockPos pos, Player player) {
        if (level instanceof LevelReader) {
            LevelReader reader = (LevelReader)level;
            return ModifyHarvestPower.isHarvestAllowed(player, reader, pos).map(x -> x != false ? 1 : 0).orElse(-1);
        }
        return -1;
    }
}

