/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import com.mojang.datafixers.util.Pair;
import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.ItemCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.item.ComparingItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.DelegatedItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.EnchantmentCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.IngredientCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.IntComparingItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.ItemHasPowerCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.NbtCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.PowerCountCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.SimpleItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Arrays;
import java.util.function.BiPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class ApoliItemConditions {
    public static final BiPredicate<ConfiguredItemCondition<?, ?>, Pair<Level, ItemStack>> PREDICATE = (config, pair) -> config.check((Level)pair.getFirst(), (ItemStack)pair.getSecond());
    public static final RegistryObject<DelegatedItemCondition<ConstantConfiguration<Pair<Level, ItemStack>>>> CONSTANT = ApoliItemConditions.of("constant");
    public static final RegistryObject<DelegatedItemCondition<ConditionStreamConfiguration<ConfiguredItemCondition<?, ?>, Pair<Level, ItemStack>>>> AND = ApoliItemConditions.of("and");
    public static final RegistryObject<DelegatedItemCondition<ConditionStreamConfiguration<ConfiguredItemCondition<?, ?>, Pair<Level, ItemStack>>>> OR = ApoliItemConditions.of("or");
    public static final RegistryObject<SimpleItemCondition> FOOD = ApoliRegisters.ITEM_CONDITIONS.register("food", () -> new SimpleItemCondition(ItemStack::m_41614_));
    public static final RegistryObject<SimpleItemCondition> MEAT = ApoliRegisters.ITEM_CONDITIONS.register("meat", () -> new SimpleItemCondition(stack -> stack.m_41614_() && stack.m_41720_().m_41473_() != null && stack.m_41720_().m_41473_().m_38746_()));
    public static final RegistryObject<IngredientCondition> INGREDIENT = ApoliRegisters.ITEM_CONDITIONS.register("ingredient", IngredientCondition::new);
    public static final RegistryObject<ComparingItemCondition> ARMOR_VALUE = ApoliRegisters.ITEM_CONDITIONS.register("armor_value", () -> new ComparingItemCondition(value -> {
        int n;
        Item patt2659$temp = value.m_41720_();
        if (patt2659$temp instanceof ArmorItem) {
            ArmorItem ai = (ArmorItem)patt2659$temp;
            n = ai.m_40404_();
        } else {
            n = 0;
        }
        return n;
    }));
    public static final RegistryObject<ComparingItemCondition> HARVEST_LEVEL = ApoliRegisters.ITEM_CONDITIONS.register("harvest_level", () -> new ComparingItemCondition(value -> {
        int n;
        Item patt2884$temp = value.m_41720_();
        if (patt2884$temp instanceof DiggerItem) {
            DiggerItem ti = (DiggerItem)patt2884$temp;
            n = ti.m_43314_().m_6604_();
        } else {
            n = 0;
        }
        return n;
    }));
    public static final RegistryObject<EnchantmentCondition> ENCHANTMENT = ApoliRegisters.ITEM_CONDITIONS.register("enchantment", EnchantmentCondition::new);
    public static final RegistryObject<NbtCondition> NBT = ApoliRegisters.ITEM_CONDITIONS.register("nbt", NbtCondition::new);
    public static final RegistryObject<SimpleItemCondition> FIREPROOF = ApoliRegisters.ITEM_CONDITIONS.register("fireproof", () -> new SimpleItemCondition(x -> x.m_41720_().m_41475_()));
    public static final RegistryObject<SimpleItemCondition> ENCHANTABLE = ApoliRegisters.ITEM_CONDITIONS.register("enchantable", () -> new SimpleItemCondition(ItemStack::m_41792_));
    public static final RegistryObject<SimpleItemCondition> EMPTY = ApoliRegisters.ITEM_CONDITIONS.register("empty", () -> new SimpleItemCondition(ItemStack::m_41619_));
    public static final RegistryObject<IntComparingItemCondition> AMOUNT = ApoliRegisters.ITEM_CONDITIONS.register("amount", () -> new IntComparingItemCondition(ItemStack::m_41613_));
    public static final RegistryObject<PowerCountCondition> POWER_COUNT = ApoliRegisters.ITEM_CONDITIONS.register("power_count", PowerCountCondition::new);
    public static final RegistryObject<ItemHasPowerCondition> HAS_POWER = ApoliRegisters.ITEM_CONDITIONS.register("has_power", ItemHasPowerCondition::new);
    public static final RegistryObject<SimpleItemCondition> SMELTABLE = ApoliRegisters.ITEM_CONDITIONS.register("smeltable", () -> new SimpleItemCondition((level, stack) -> SimpleItemCondition.forCookingRecipeType(level, stack, (RecipeType<? extends AbstractCookingRecipe>)RecipeType.f_44108_)));

    private static <U extends ItemCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.of((ResourceLocation)Apoli.identifier(name), ApoliRegistries.ITEM_CONDITION_CLASS, (String)"apoli");
    }

    public static ConfiguredItemCondition<?, ?> constant(boolean value) {
        return (ConfiguredItemCondition)((DelegatedItemCondition)CONSTANT.get()).configure(new ConstantConfiguration(value));
    }

    public static ConfiguredItemCondition<?, ?> and(ConfiguredItemCondition<?, ?> ... conditions) {
        return (ConfiguredItemCondition)((DelegatedItemCondition)AND.get()).configure(ConditionStreamConfiguration.and(Arrays.asList(conditions), PREDICATE));
    }

    public static ConfiguredItemCondition<?, ?> or(ConfiguredItemCondition<?, ?> ... conditions) {
        return (ConfiguredItemCondition)((DelegatedItemCondition)OR.get()).configure(ConditionStreamConfiguration.or(Arrays.asList(conditions), PREDICATE));
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.ITEM_CONDITIONS, DelegatedItemCondition::new, ConfiguredItemCondition.CODEC, PREDICATE);
    }
}

