/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredDamageCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.DamageCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.damage.AmountCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.AttackerCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.DelegatedDamageCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.FireDamageCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.NameCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.ProjectileCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Arrays;
import java.util.function.BiPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class ApoliDamageConditions {
    public static final BiPredicate<ConfiguredDamageCondition<?, ?>, Pair<DamageSource, Float>> PREDICATE = (config, pair) -> config.check((DamageSource)pair.getLeft(), ((Float)pair.getRight()).floatValue());
    public static final RegistryObject<DelegatedDamageCondition<ConstantConfiguration<Pair<DamageSource, Float>>>> CONSTANT = ApoliDamageConditions.of("constant");
    public static final RegistryObject<DelegatedDamageCondition<ConditionStreamConfiguration<ConfiguredDamageCondition<?, ?>, Pair<DamageSource, Float>>>> AND = ApoliDamageConditions.of("and");
    public static final RegistryObject<DelegatedDamageCondition<ConditionStreamConfiguration<ConfiguredDamageCondition<?, ?>, Pair<DamageSource, Float>>>> OR = ApoliDamageConditions.of("or");
    public static final RegistryObject<AmountCondition> AMOUNT = ApoliRegisters.DAMAGE_CONDITIONS.register("amount", AmountCondition::new);
    public static final RegistryObject<NameCondition> NAME = ApoliRegisters.DAMAGE_CONDITIONS.register("name", NameCondition::new);
    public static final RegistryObject<FireDamageCondition> FIRE = ApoliRegisters.DAMAGE_CONDITIONS.register("fire", FireDamageCondition::new);
    public static final RegistryObject<ProjectileCondition> PROJECTILE = ApoliRegisters.DAMAGE_CONDITIONS.register("projectile", ProjectileCondition::new);
    public static final RegistryObject<AttackerCondition> ATTACKER = ApoliRegisters.DAMAGE_CONDITIONS.register("attacker", AttackerCondition::new);

    private static <U extends DamageCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.of((ResourceLocation)Apoli.identifier(name), ApoliRegistries.DAMAGE_CONDITION_CLASS, (String)"apoli");
    }

    public static ConfiguredDamageCondition<?, ?> constant(boolean value) {
        return (ConfiguredDamageCondition)((DelegatedDamageCondition)CONSTANT.get()).configure(new ConstantConfiguration(value));
    }

    public static ConfiguredDamageCondition<?, ?> and(ConfiguredDamageCondition<?, ?> ... conditions) {
        return (ConfiguredDamageCondition)((DelegatedDamageCondition)AND.get()).configure(ConditionStreamConfiguration.and(Arrays.asList(conditions), PREDICATE));
    }

    public static ConfiguredDamageCondition<?, ?> or(ConfiguredDamageCondition<?, ?> ... conditions) {
        return (ConfiguredDamageCondition)((DelegatedDamageCondition)OR.get()).configure(ConditionStreamConfiguration.or(Arrays.asList(conditions), PREDICATE));
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.DAMAGE_CONDITIONS, DelegatedDamageCondition::new, ConfiguredDamageCondition.CODEC, PREDICATE);
    }
}

