/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import com.mojang.datafixers.util.Pair;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.factory.condition.bientity.RelativeRotationCondition;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiomeCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.BiEntityCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.bientity.DelegatedBiEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.bientity.DispatchBiEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.bientity.DoubleComparingBiEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.bientity.DualBiEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.bientity.LineOfSightCondition;
import io.github.edwinmindcraft.apoli.common.condition.bientity.SimpleBiEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.registries.RegistryObject;

public class ApoliBiEntityConditions {
    public static final BiPredicate<ConfiguredBiEntityCondition<?, ?>, Pair<Entity, Entity>> PREDICATE = (config, pair) -> config.check((Entity)pair.getFirst(), (Entity)pair.getSecond());
    public static final RegistryObject<DelegatedBiEntityCondition<ConstantConfiguration<Pair<Entity, Entity>>>> CONSTANT = ApoliBiEntityConditions.of("constant");
    public static final RegistryObject<DelegatedBiEntityCondition<ConditionStreamConfiguration<ConfiguredBiomeCondition<?, ?>, Pair<Entity, Entity>>>> AND = ApoliBiEntityConditions.of("and");
    public static final RegistryObject<DelegatedBiEntityCondition<ConditionStreamConfiguration<ConfiguredBiomeCondition<?, ?>, Pair<Entity, Entity>>>> OR = ApoliBiEntityConditions.of("or");
    public static final RegistryObject<DualBiEntityCondition> INVERT = ApoliRegisters.BIENTITY_CONDITIONS.register("invert", DualBiEntityCondition::invert);
    public static final RegistryObject<DispatchBiEntityCondition> ACTOR_CONDITION = ApoliRegisters.BIENTITY_CONDITIONS.register("actor_condition", DispatchBiEntityCondition::actor);
    public static final RegistryObject<DispatchBiEntityCondition> TARGET_CONDITION = ApoliRegisters.BIENTITY_CONDITIONS.register("target_condition", DispatchBiEntityCondition::target);
    public static final RegistryObject<DispatchBiEntityCondition> EITHER = ApoliRegisters.BIENTITY_CONDITIONS.register("either", DispatchBiEntityCondition::either);
    public static final RegistryObject<DispatchBiEntityCondition> BOTH = ApoliRegisters.BIENTITY_CONDITIONS.register("both", DispatchBiEntityCondition::both);
    public static final RegistryObject<DualBiEntityCondition> UNDIRECTED = ApoliRegisters.BIENTITY_CONDITIONS.register("undirected", DualBiEntityCondition::undirected);
    public static final RegistryObject<DoubleComparingBiEntityCondition> DISTANCE = ApoliRegisters.BIENTITY_CONDITIONS.register("distance", () -> new DoubleComparingBiEntityCondition(Entity::m_20270_));
    public static final RegistryObject<LineOfSightCondition> CAN_SEE = ApoliRegisters.BIENTITY_CONDITIONS.register("can_see", LineOfSightCondition::new);
    public static final RegistryObject<SimpleBiEntityCondition> OWNER = ApoliRegisters.BIENTITY_CONDITIONS.register("owner", () -> new SimpleBiEntityCondition((actor, target) -> {
        TamableAnimal animal;
        return target instanceof TamableAnimal && Objects.equals(actor, (animal = (TamableAnimal)target).m_142480_());
    }));
    public static final RegistryObject<SimpleBiEntityCondition> RIDING = ApoliRegisters.BIENTITY_CONDITIONS.register("riding", () -> new SimpleBiEntityCondition((actor, target) -> Objects.equals(actor.m_20202_(), target)));
    public static final RegistryObject<SimpleBiEntityCondition> RIDING_ROOT = ApoliRegisters.BIENTITY_CONDITIONS.register("riding_root", () -> new SimpleBiEntityCondition((actor, target) -> Objects.equals(actor.m_20201_(), target)));
    public static final RegistryObject<SimpleBiEntityCondition> RIDING_RECURSIVE = ApoliRegisters.BIENTITY_CONDITIONS.register("riding_recursive", () -> new SimpleBiEntityCondition(SimpleBiEntityCondition::ridingRecursive));
    public static final RegistryObject<SimpleBiEntityCondition> ATTACK_TARGET = ApoliRegisters.BIENTITY_CONDITIONS.register("attack_target", () -> new SimpleBiEntityCondition((actor, target) -> {
        NeutralMob n;
        Mob mob;
        return actor instanceof Mob && Objects.equals(target, (mob = (Mob)actor).m_5448_()) || actor instanceof NeutralMob && Objects.equals(target, (n = (NeutralMob)actor).m_5448_());
    }));
    public static final RegistryObject<SimpleBiEntityCondition> ATTACKER = ApoliRegisters.BIENTITY_CONDITIONS.register("attacker", () -> new SimpleBiEntityCondition((actor, target) -> {
        LivingEntity living;
        return target instanceof LivingEntity && Objects.equals(actor, (living = (LivingEntity)target).m_142581_());
    }));
    public static final RegistryObject<RelativeRotationCondition> RELATIVE_ROTATION = ApoliRegisters.BIENTITY_CONDITIONS.register("relative_rotation", RelativeRotationCondition::new);

    private static <U extends BiEntityCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.of((ResourceLocation)Apoli.identifier(name), ApoliRegistries.BIENTITY_CONDITION_CLASS, (String)"apoli");
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.BIENTITY_CONDITIONS, DelegatedBiEntityCondition::new, ConfiguredBiEntityCondition.CODEC, PREDICATE);
    }
}

