/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.action;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.action.block.BonemealAction;
import io.github.apace100.apoli.power.factory.action.block.ExplodeAction;
import io.github.apace100.apoli.power.factory.action.block.ModifyBlockStateAction;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.BlockAction;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.action.block.AddBlockAction;
import io.github.edwinmindcraft.apoli.common.action.block.DelegatedBlockAction;
import io.github.edwinmindcraft.apoli.common.action.block.ExecuteCommandBlockAction;
import io.github.edwinmindcraft.apoli.common.action.block.OffsetAction;
import io.github.edwinmindcraft.apoli.common.action.block.SetBlockAction;
import io.github.edwinmindcraft.apoli.common.action.meta.ChanceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.ChoiceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.DelayAction;
import io.github.edwinmindcraft.apoli.common.action.meta.IfElseConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.NothingConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.StreamConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Triple;

public class ApoliBlockActions {
    public static final BiConsumer<ConfiguredBlockAction<?, ?>, Triple<Level, BlockPos, Direction>> EXECUTOR = (action, o) -> action.execute((Level)o.getLeft(), (BlockPos)o.getMiddle(), (Direction)o.getRight());
    public static final BiPredicate<ConfiguredBlockCondition<?, ?>, Triple<Level, BlockPos, Direction>> PREDICATE = (condition, triple) -> ConfiguredBlockCondition.check(condition, (LevelReader)triple.getLeft(), (BlockPos)triple.getMiddle());
    public static final RegistryObject<DelegatedBlockAction<StreamConfiguration<ConfiguredBlockAction<?, ?>, Triple<Level, BlockPos, Direction>>>> AND = ApoliBlockActions.of("and");
    public static final RegistryObject<DelegatedBlockAction<ChanceConfiguration<ConfiguredBlockAction<?, ?>, Triple<Level, BlockPos, Direction>>>> CHANCE = ApoliBlockActions.of("chance");
    public static final RegistryObject<DelegatedBlockAction<IfElseConfiguration<ConfiguredBlockCondition<?, ?>, ConfiguredBlockAction<?, ?>, Triple<Level, BlockPos, Direction>>>> IF_ELSE = ApoliBlockActions.of("if_else");
    public static final RegistryObject<DelegatedBlockAction<StreamConfiguration<ConfiguredBlockAction<?, ?>, Triple<Level, BlockPos, Direction>>>> IF_ELSE_LIST = ApoliBlockActions.of("if_else_list");
    public static final RegistryObject<DelegatedBlockAction<ChoiceConfiguration<ConfiguredBlockAction<?, ?>, Triple<Level, BlockPos, Direction>>>> CHOICE = ApoliBlockActions.of("choice");
    public static final RegistryObject<DelegatedBlockAction<DelayAction<ConfiguredBlockAction<?, ?>, Triple<Level, BlockPos, Direction>>>> DELAY = ApoliBlockActions.of("delay");
    public static final RegistryObject<DelegatedBlockAction<NothingConfiguration<Triple<Level, BlockPos, Direction>>>> NOTHING = ApoliBlockActions.of("nothing");
    public static final RegistryObject<OffsetAction> OFFSET = ApoliRegisters.BLOCK_ACTIONS.register("offset", OffsetAction::new);
    public static final RegistryObject<SetBlockAction> SET_BLOCK = ApoliRegisters.BLOCK_ACTIONS.register("set_block", SetBlockAction::new);
    public static final RegistryObject<AddBlockAction> ADD_BLOCK = ApoliRegisters.BLOCK_ACTIONS.register("add_block", AddBlockAction::new);
    public static final RegistryObject<ExecuteCommandBlockAction> EXECUTE_COMMAND = ApoliRegisters.BLOCK_ACTIONS.register("execute_command", ExecuteCommandBlockAction::new);
    public static final RegistryObject<BonemealAction> BONEMEAL = ApoliRegisters.BLOCK_ACTIONS.register("bonemeal", BonemealAction::new);
    public static final RegistryObject<ModifyBlockStateAction> MODIFY_BLOCK_STATE = ApoliRegisters.BLOCK_ACTIONS.register("modify_block_state", ModifyBlockStateAction::new);
    public static final RegistryObject<ExplodeAction> EXPLODE = ApoliRegisters.BLOCK_ACTIONS.register("explode", ExplodeAction::new);

    private static <U extends BlockAction<?>> RegistryObject<U> of(String name) {
        return RegistryObject.of((ResourceLocation)Apoli.identifier(name), ApoliRegistries.BLOCK_ACTION_CLASS, (String)"apoli");
    }

    public static void bootstrap() {
        MetaFactories.defineMetaActions(ApoliRegisters.BLOCK_ACTIONS, DelegatedBlockAction::new, ConfiguredBlockAction.CODEC, ConfiguredBlockCondition.CODEC, EXECUTOR, PREDICATE);
    }
}

