/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record RestrictArmorConfiguration(Map<EquipmentSlot, ConfiguredItemCondition<?, ?>> conditions, int tickRate) implements IDynamicFeatureConfiguration
{
    private static final MapCodec<Map<EquipmentSlot, ConfiguredItemCondition<?, ?>>> EQUIPMENT_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(ConfiguredItemCondition.CODEC, "head").forGetter(x -> Optional.ofNullable((ConfiguredItemCondition)x.get(EquipmentSlot.HEAD))), (App)CalioCodecHelper.optionalField(ConfiguredItemCondition.CODEC, "chest").forGetter(x -> Optional.ofNullable((ConfiguredItemCondition)x.get(EquipmentSlot.CHEST))), (App)CalioCodecHelper.optionalField(ConfiguredItemCondition.CODEC, "legs").forGetter(x -> Optional.ofNullable((ConfiguredItemCondition)x.get(EquipmentSlot.LEGS))), (App)CalioCodecHelper.optionalField(ConfiguredItemCondition.CODEC, "feet").forGetter(x -> Optional.ofNullable((ConfiguredItemCondition)x.get(EquipmentSlot.FEET)))).apply((Applicative)instance, (head, chest, legs, feet) -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        head.ifPresent(x -> builder.put((Object)EquipmentSlot.HEAD, x));
        chest.ifPresent(x -> builder.put((Object)EquipmentSlot.CHEST, x));
        legs.ifPresent(x -> builder.put((Object)EquipmentSlot.LEGS, x));
        feet.ifPresent(x -> builder.put((Object)EquipmentSlot.FEET, x));
        return builder.build();
    }));
    public static final Codec<RestrictArmorConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EQUIPMENT_MAP_CODEC.forGetter(RestrictArmorConfiguration::conditions), (App)CalioCodecHelper.optionalField(Codec.INT, "tick_rate", 80).forGetter(RestrictArmorConfiguration::tickRate)).apply((Applicative)instance, RestrictArmorConfiguration::new));

    public boolean check(EquipmentSlot slot, Level level, ItemStack stack) {
        return ConfiguredItemCondition.check(this.conditions.get(slot), level, stack);
    }

    public void dropIllegalItems(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        this.conditions().forEach((slot, predicate) -> {
            if (predicate == null) {
                return;
            }
            ItemStack equippedItem = living.m_6844_(slot);
            if (!equippedItem.m_41619_() && predicate.check(living.f_19853_, equippedItem)) {
                if (entity instanceof Player) {
                    Player ple = (Player)entity;
                    if (!ple.m_150109_().m_36054_(equippedItem)) {
                        ple.m_36176_(equippedItem, true);
                    }
                } else {
                    entity.m_19983_(equippedItem);
                }
                entity.m_8061_(slot, ItemStack.f_41583_);
            }
        });
    }
}

