/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public record PhasingConfiguration(@Nullable ConfiguredBlockCondition<?, ?> phaseCondition, boolean blacklist, RenderType renderType, float viewDistance, @Nullable ConfiguredEntityCondition<?, ?> phaseDownCondition) implements IDynamicFeatureConfiguration
{
    public static final Codec<PhasingConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField(ConfiguredBlockCondition.CODEC, "block_condition").forGetter(x -> Optional.ofNullable(x.phaseCondition())), (App)CalioCodecHelper.optionalField(Codec.BOOL, "blacklist", false).forGetter(PhasingConfiguration::blacklist), (App)SerializableDataType.enumValue(RenderType.class).optionalFieldOf("render_type", (Object)RenderType.BLINDNESS).forGetter(PhasingConfiguration::renderType), (App)CalioCodecHelper.optionalField(Codec.FLOAT, "view_distance", Float.valueOf(10.0f)).forGetter(PhasingConfiguration::viewDistance), (App)CalioCodecHelper.optionalField(ConfiguredEntityCondition.CODEC, "phase_down_condition").forGetter(x -> Optional.ofNullable(x.phaseDownCondition()))).apply((Applicative)instance, (t1, t2, t3, t4, t5) -> new PhasingConfiguration(t1.orElse(null), (boolean)t2, (RenderType)((Object)((Object)t3)), t4.floatValue(), t5.orElse(null))));

    public boolean canPhaseDown(Entity entity) {
        return this.phaseDownCondition() == null ? entity.m_6047_() : this.phaseDownCondition().check(entity);
    }

    public boolean canPhaseThrough(LevelReader reader, BlockPos pos, NonNullSupplier<BlockState> stateGetter) {
        return this.blacklist() != ConfiguredBlockCondition.check(this.phaseCondition(), reader, pos, stateGetter);
    }

    public static enum RenderType {
        BLINDNESS,
        REMOVE_BLOCKS,
        NONE;

    }
}

