/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import org.jetbrains.annotations.NotNull;

public record ParticleConfiguration(ParticleType<?> particle, int frequency, boolean visibleInFirstPerson) implements IDynamicFeatureConfiguration
{
    public static final Codec<ParticleConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.PARTICLE_TYPE.fieldOf("particle").forGetter(ParticleConfiguration::particle), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("frequency").forGetter(ParticleConfiguration::frequency), (App)CalioCodecHelper.optionalField(Codec.BOOL, "visible_in_first_person", false).forGetter(ParticleConfiguration::visibleInFirstPerson)).apply((Applicative)instance, ParticleConfiguration::new));

    @Override
    @NotNull
    public List<String> getWarnings(@NotNull ICalioDynamicRegistryManager server) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.particle() == null) {
            builder.add((Object)"Optional particle was missing.");
        }
        return ImmutableList.of();
    }

    @Override
    public boolean isConfigurationValid() {
        return this.particle() instanceof ParticleOptions;
    }
}

