/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public record MultipleConfiguration<V>(Map<String, V> children) implements IDynamicFeatureConfiguration
{
    public static <V> MapCodec<MultipleConfiguration<V>> mapCodec(Codec<V> codec, Predicate<String> filter, UnaryOperator<String> keyMapper, Function3<String, V, JsonElement, V> configurator) {
        return new MultipleMapCodec<V>(codec, filter, keyMapper, configurator);
    }

    private static final class MultipleMapCodec<V>
    extends MapCodec<MultipleConfiguration<V>> {
        private final Codec<V> codec;
        private final Predicate<String> keyFilter;
        private final UnaryOperator<String> keyMapper;
        private final Function3<String, V, JsonElement, V> configurator;

        private MultipleMapCodec(Codec<V> codec, Predicate<String> keyFilter, UnaryOperator<String> keyMapper, Function3<String, V, JsonElement, V> configurator) {
            this.codec = codec;
            this.keyFilter = keyFilter;
            this.keyMapper = keyMapper;
            this.configurator = configurator;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return ops.compressMaps() ? Stream.of(ops.createString("values")) : Stream.empty();
        }

        private boolean useJson(DynamicOps<?> ops) {
            return ops instanceof JsonOps && !ops.compressMaps();
        }

        public <T> DataResult<MultipleConfiguration<V>> decode(DynamicOps<T> ops, MapLike<T> input) {
            DataResult root = ops.compressMaps() ? ops.getMap(input.get("values")) : DataResult.success(input);
            return root.flatMap(map -> {
                ImmutableMap.Builder successes = ImmutableMap.builder();
                ImmutableSet.Builder failures = ImmutableSet.builder();
                map.entries().forEach(entry -> {
                    DataResult stringValue = ops.getStringValue(entry.getFirst());
                    if (stringValue.result().filter(this.keyFilter).isPresent()) {
                        stringValue.flatMap(name -> this.codec.decode(ops, entry.getSecond()).map(x -> new ImmutableTriple(name, x.getFirst(), entry.getSecond()))).resultOrPartial(arg_0 -> ((ImmutableSet.Builder)failures).add(arg_0)).ifPresent(pair -> {
                            if (this.useJson(ops)) {
                                successes.put((Object)((String)this.keyMapper.apply((String)pair.getLeft())), this.configurator.apply((Object)((String)pair.getLeft()), pair.getMiddle(), (Object)((JsonElement)pair.getRight())));
                            } else {
                                successes.put((Object)((String)pair.getLeft()), pair.getMiddle());
                            }
                        });
                    }
                });
                ImmutableSet build = failures.build();
                MultipleConfiguration configuration = new MultipleConfiguration(successes.build());
                if (!build.isEmpty()) {
                    return DataResult.error((String)("Failed to read fields: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)build)), configuration);
                }
                return DataResult.success(configuration);
            });
        }

        public <T> RecordBuilder<T> encode(MultipleConfiguration<V> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            RecordBuilder root = ops.compressMaps() ? ops.mapBuilder() : prefix;
            input.children().forEach((key, value) -> root.add(key, this.codec.encodeStart(ops, value)));
            if (ops.compressMaps()) {
                prefix.add("values", root.build(ops.empty()));
            }
            return prefix;
        }
    }
}

