/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class ModifyFallingConfiguration
implements IDynamicFeatureConfiguration {
    private static final Random RANDOM = new Random();
    public static final Codec<ModifyFallingConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("velocity").forGetter(ModifyFallingConfiguration::velocity), (App)CalioCodecHelper.optionalField(Codec.BOOL, "take_fall_damage", true).forGetter(ModifyFallingConfiguration::takeFallDamage)).apply((Applicative)instance, ModifyFallingConfiguration::new));
    private final double velocity;
    private final boolean takeFallDamage;
    private AttributeModifier cache;

    public ModifyFallingConfiguration(double velocity, boolean takeFallDamage) {
        this.velocity = velocity;
        this.takeFallDamage = takeFallDamage;
    }

    public AttributeModifier modifier(ResourceLocation registryName) {
        if (this.cache == null) {
            RANDOM.setSeed((long)registryName.m_135827_().hashCode() << 32 | (long)registryName.m_135815_().hashCode());
            UUID uuid = new UUID(RANDOM.nextLong(), RANDOM.nextLong());
            this.cache = new AttributeModifier(uuid, "Modify Falling", this.velocity() - (double)0.08f, AttributeModifier.Operation.ADDITION);
        }
        return this.cache;
    }

    public double velocity() {
        return this.velocity;
    }

    public boolean takeFallDamage() {
        return this.takeFallDamage;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModifyFallingConfiguration that = (ModifyFallingConfiguration)obj;
        return Double.doubleToLongBits(this.velocity) == Double.doubleToLongBits(that.velocity) && this.takeFallDamage == that.takeFallDamage;
    }

    public int hashCode() {
        return Objects.hash(this.velocity, this.takeFallDamage);
    }

    public String toString() {
        return "ModifyFallingConfiguration[velocity=" + this.velocity + ", takeFallDamage=" + this.takeFallDamage + "]";
    }
}

