/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public record ItemOnItemConfiguration(@Nullable ConfiguredItemCondition<?, ?> usingItemCondition, @Nullable ConfiguredItemCondition<?, ?> onItemCondition, int resultFromOnStack, @Nullable ItemStack newStack, @Nullable ConfiguredItemAction<?, ?> usingItemAction, @Nullable ConfiguredItemAction<?, ?> onItemAction, @Nullable ConfiguredItemAction<?, ?> resultItemAction, @Nullable ConfiguredEntityAction<?, ?> entityAction) implements IDynamicFeatureConfiguration
{
    public static final Codec<ItemOnItemConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField(ConfiguredItemCondition.CODEC, "using_item_condition").forGetter(x -> Optional.ofNullable(x.usingItemCondition())), (App)CalioCodecHelper.optionalField(ConfiguredItemCondition.CODEC, "on_item_condition").forGetter(x -> Optional.ofNullable(x.onItemCondition())), (App)CalioCodecHelper.optionalField(Codec.INT, "result_from_on_stack", 0).forGetter(ItemOnItemConfiguration::resultFromOnStack), (App)CalioCodecHelper.optionalField(SerializableDataTypes.ITEM_STACK, "result").forGetter(x -> Optional.ofNullable(x.newStack())), (App)CalioCodecHelper.optionalField(ConfiguredItemAction.CODEC, "using_item_action").forGetter(x -> Optional.ofNullable(x.usingItemAction())), (App)CalioCodecHelper.optionalField(ConfiguredItemAction.CODEC, "on_item_action").forGetter(x -> Optional.ofNullable(x.onItemAction())), (App)CalioCodecHelper.optionalField(ConfiguredItemAction.CODEC, "result_item_action").forGetter(x -> Optional.ofNullable(x.resultItemAction())), (App)CalioCodecHelper.optionalField(ConfiguredEntityAction.CODEC, "entity_action").forGetter(x -> Optional.ofNullable(x.entityAction()))).apply((Applicative)instance, (t1, t2, t3, t4, t5, t6, t7, t8) -> new ItemOnItemConfiguration(t1.orElse(null), t2.orElse(null), (int)t3, t4.orElse(null), t5.orElse(null), t6.orElse(null), t7.orElse(null), t8.orElse(null))));

    public boolean check(Level level, ItemStack using, ItemStack on) {
        return ConfiguredItemCondition.check(this.usingItemCondition(), level, using) && ConfiguredItemCondition.check(this.onItemCondition(), level, on);
    }

    public void execute(Entity entity, Mutable<ItemStack> using, Mutable<ItemStack> on, Slot slot) {
        MutableObject stack = new MutableObject((Object)ItemStack.f_41583_);
        if (this.newStack() != null) {
            stack.setValue((Object)this.newStack().m_41777_());
        } else if (this.resultFromOnStack() > 0) {
            stack.setValue((Object)((ItemStack)on.getValue()).m_41620_(this.resultFromOnStack()));
        } else {
            stack.setValue((Object)((ItemStack)on.getValue()));
        }
        ConfiguredItemAction.execute(this.resultItemAction(), entity.f_19853_, (Mutable<ItemStack>)stack);
        ConfiguredItemAction.execute(this.usingItemAction(), entity.f_19853_, using);
        ConfiguredItemAction.execute(this.onItemAction(), entity.f_19853_, on);
        if (this.newStack() != null || this.resultItemAction() != null) {
            if (slot.m_7993_().m_41619_()) {
                slot.m_5852_((ItemStack)stack.getValue());
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_150109_().m_150079_((ItemStack)stack.getValue());
            }
        }
        ConfiguredEntityAction.execute(this.entityAction(), entity);
    }
}

