/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.IActiveCooldownPowerConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record FireProjectileConfiguration(int cooldown, HudRender hudRender, EntityType<?> entityType, int projectileCount, float speed, float divergence, @Nullable SoundEvent soundEvent, @Nullable CompoundTag tag, IActivePower.Key key, int interval, int startDelay) implements IActiveCooldownPowerConfiguration
{
    public static final Codec<FireProjectileConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("cooldown").forGetter(FireProjectileConfiguration::cooldown), (App)ApoliDataTypes.HUD_RENDER.fieldOf("hud_render").forGetter(FireProjectileConfiguration::hudRender), (App)Registry.f_122826_.m_194605_().fieldOf("entity_type").forGetter(FireProjectileConfiguration::entityType), (App)CalioCodecHelper.optionalField(Codec.INT, "count", 1).forGetter(FireProjectileConfiguration::projectileCount), (App)CalioCodecHelper.optionalField(Codec.FLOAT, "speed", Float.valueOf(1.5f)).forGetter(FireProjectileConfiguration::speed), (App)CalioCodecHelper.optionalField(Codec.FLOAT, "divergence", Float.valueOf(1.0f)).forGetter(FireProjectileConfiguration::divergence), (App)CalioCodecHelper.optionalField(SerializableDataTypes.SOUND_EVENT, "sound").forGetter(x -> Optional.ofNullable(x.soundEvent())), (App)CalioCodecHelper.optionalField(SerializableDataTypes.NBT, "tag").forGetter(x -> Optional.ofNullable(x.tag())), (App)CalioCodecHelper.optionalField(IActivePower.Key.BACKWARD_COMPATIBLE_CODEC, "key", IActivePower.Key.PRIMARY).forGetter(FireProjectileConfiguration::key), (App)CalioCodecHelper.optionalField(Codec.INT, "interval", 0).forGetter(FireProjectileConfiguration::interval), (App)CalioCodecHelper.optionalField(Codec.INT, "start_delay", 0).forGetter(FireProjectileConfiguration::startDelay)).apply((Applicative)instance, (t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) -> new FireProjectileConfiguration((int)t1, (HudRender)t2, (EntityType<?>)t3, (int)t4, t5.floatValue(), t6.floatValue(), t7.orElse(null), t8.orElse(null), (IActivePower.Key)t9, (int)t10, (int)t11)));

    public void playSound(Entity player) {
        if (this.soundEvent != null) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.soundEvent, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.f_19853_.m_5822_().nextFloat() * 0.4f + 0.8f));
        }
    }

    public void fireProjectile(Entity source) {
        if (this.entityType() != null) {
            Entity entity = this.entityType().m_20615_(source.f_19853_);
            if (entity == null) {
                return;
            }
            Vec3 rotationVector = source.m_20154_();
            float yaw = source.m_146908_();
            float pitch = source.m_146909_();
            Vec3 spawnPos = source.m_20182_().m_82520_(0.0, (double)source.getEyeHeightAccess(source.m_20089_(), source.m_6972_(source.m_20089_())), 0.0).m_82549_(rotationVector);
            entity.m_7678_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), pitch, yaw);
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                if (entity instanceof AbstractHurtingProjectile) {
                    AbstractHurtingProjectile ahp = (AbstractHurtingProjectile)entity;
                    ahp.f_36813_ = rotationVector.f_82479_ * (double)this.speed;
                    ahp.f_36814_ = rotationVector.f_82480_ * (double)this.speed;
                    ahp.f_36815_ = rotationVector.f_82481_ * (double)this.speed;
                }
                projectile.m_5602_(source);
                projectile.m_37251_(source, pitch, yaw, 0.0f, this.speed(), this.divergence());
            } else {
                float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                float g = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
                float h = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                Vec3 vec3d = new Vec3((double)f, (double)g, (double)h).m_82541_().m_82520_(source.f_19853_.m_5822_().nextGaussian() * (double)0.0075f * (double)this.divergence(), source.f_19853_.m_5822_().nextGaussian() * (double)0.0075f * (double)this.divergence(), source.f_19853_.m_5822_().nextGaussian() * (double)0.0075f * (double)this.divergence()).m_82490_((double)this.speed());
                entity.m_20256_(vec3d);
                Vec3 entityVelo = source.m_20184_();
                entity.m_20256_(entity.m_20184_().m_82520_(entityVelo.f_82479_, source.m_20096_() ? 0.0 : entityVelo.f_82480_, entityVelo.f_82481_));
            }
            if (this.tag != null) {
                CompoundTag mergedTag = entity.m_20240_(new CompoundTag());
                mergedTag.m_128391_(this.tag);
                entity.m_20258_(mergedTag);
            }
            source.f_19853_.m_7967_(entity);
        }
    }

    @Override
    public int duration() {
        return this.cooldown();
    }
}

