/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.HudRender;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredDamageCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.ICooldownPowerConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public record ConditionedCombatActionConfiguration(int duration, HudRender hudRender, @Nullable ConfiguredDamageCondition<?, ?> damageCondition, @Nullable ConfiguredEntityCondition<?, ?> targetCondition, ConfiguredEntityAction<?, ?> entityAction) implements ICooldownPowerConfiguration
{
    public static final Codec<ConditionedCombatActionConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("cooldown").forGetter(ConditionedCombatActionConfiguration::duration), (App)CalioCodecHelper.optionalField(ApoliDataTypes.HUD_RENDER, "hud_render", HudRender.DONT_RENDER).forGetter(ConditionedCombatActionConfiguration::hudRender), (App)CalioCodecHelper.optionalField(ConfiguredDamageCondition.CODEC, "damage_condition").forGetter(x -> Optional.ofNullable(x.damageCondition())), (App)CalioCodecHelper.optionalField(ConfiguredEntityCondition.CODEC, "target_condition").forGetter(x -> Optional.ofNullable(x.targetCondition())), (App)ConfiguredEntityAction.CODEC.fieldOf("entity_action").forGetter(ConditionedCombatActionConfiguration::entityAction)).apply((Applicative)instance, (t1, t2, t3, t4, t5) -> new ConditionedCombatActionConfiguration((int)t1, (HudRender)t2, t3.orElse(null), t4.orElse(null), (ConfiguredEntityAction<?, ?>)t5)));

    public boolean check(Entity target, DamageSource source, float amount) {
        return ConfiguredEntityCondition.check(this.targetCondition(), target) && ConfiguredDamageCondition.check(this.damageCondition(), source, amount);
    }
}

