/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.InteractionPowerConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.Nullable;

public record BlockInteractionConfiguration(@Nullable ConfiguredBlockCondition<?, ?> blockCondition, @Nullable ConfiguredBlockAction<?, ?> blockAction, EnumSet<Direction> directions, @Nullable ConfiguredEntityAction<?, ?> entityAction, InteractionPowerConfiguration interaction) implements IDynamicFeatureConfiguration
{
    public static final Codec<BlockInteractionConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField(ConfiguredBlockCondition.CODEC, "block_condition").forGetter(x -> Optional.ofNullable(x.blockCondition())), (App)CalioCodecHelper.optionalField(ConfiguredBlockAction.CODEC, "block_action").forGetter(x -> Optional.ofNullable(x.blockAction())), (App)CalioCodecHelper.optionalField(SerializableDataTypes.DIRECTION_SET, "directions", () -> EnumSet.allOf(Direction.class)).forGetter(BlockInteractionConfiguration::directions), (App)CalioCodecHelper.optionalField(ConfiguredEntityAction.CODEC, "entity_action").forGetter(x -> Optional.ofNullable(x.entityAction())), (App)InteractionPowerConfiguration.MAP_CODEC.forGetter(BlockInteractionConfiguration::interaction)).apply((Applicative)instance, (t1, t2, t3, t4, t5) -> new BlockInteractionConfiguration(t1.orElse(null), t2.orElse(null), (EnumSet<Direction>)t3, t4.orElse(null), (InteractionPowerConfiguration)t5)));

    public boolean check(Level level, BlockPos blockPos, Direction direction, InteractionHand hand, ItemStack heldStack) {
        if (!this.interaction().appliesTo(level, hand, heldStack)) {
            return false;
        }
        if (!this.directions().contains(direction)) {
            return false;
        }
        return ConfiguredBlockCondition.check(this.blockCondition(), (LevelReader)level, blockPos);
    }

    public InteractionResult executeAction(Entity entity, BlockPos blockPos, Direction direction, InteractionHand hand) {
        ConfiguredBlockAction.execute(this.blockAction(), entity.f_19853_, blockPos, direction);
        ConfiguredEntityAction.execute(this.entityAction(), entity);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.interaction().performActorItemStuff(living, hand);
        }
        return this.interaction().actionResult();
    }
}

