/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.ListConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;

public record AttributeConfiguration(ListConfiguration<AttributedEntityAttributeModifier> modifiers, boolean updateHealth) implements IDynamicFeatureConfiguration
{
    public static final MapCodec<AttributeConfiguration> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ListConfiguration.mapCodec(ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIER, "modifier", "modifiers").forGetter(AttributeConfiguration::modifiers), (App)CalioCodecHelper.optionalField(Codec.BOOL, "update_health", true).forGetter(AttributeConfiguration::updateHealth)).apply((Applicative)instance, AttributeConfiguration::new));
    public static final Codec<AttributeConfiguration> CODEC = MAP_CODEC.codec();

    public void add(Entity entity) {
        LivingEntity living;
        block5: {
            block4: {
                if (!(entity instanceof LivingEntity)) break block4;
                living = (LivingEntity)entity;
                if (!entity.f_19853_.m_5776_()) break block5;
            }
            return;
        }
        float previousMaxHealth = living.m_21233_();
        float previousHealthPercent = living.m_21223_() / previousMaxHealth;
        this.modifiers().getContent().stream().filter(x -> living.m_21204_().m_22171_(x.attribute())).forEach(mod -> {
            AttributeInstance attributeInstance = living.m_21051_(mod.attribute());
            if (attributeInstance != null && !attributeInstance.m_22109_(mod.modifier())) {
                attributeInstance.m_22118_(mod.modifier());
            }
        });
        float afterMaxHealth = living.m_21233_();
        if (this.updateHealth() && afterMaxHealth != previousMaxHealth) {
            living.m_21153_(afterMaxHealth * previousHealthPercent);
        }
    }

    public void remove(Entity entity) {
        LivingEntity living;
        block5: {
            block4: {
                if (!(entity instanceof LivingEntity)) break block4;
                living = (LivingEntity)entity;
                if (!entity.f_19853_.m_5776_()) break block5;
            }
            return;
        }
        float previousMaxHealth = living.m_21233_();
        float previousHealthPercent = living.m_21223_() / previousMaxHealth;
        this.modifiers().getContent().stream().filter(x -> living.m_21204_().m_22171_(x.attribute())).forEach(mod -> {
            AttributeInstance attributeInstance = living.m_21051_(mod.attribute());
            if (attributeInstance != null && attributeInstance.m_22109_(mod.modifier())) {
                attributeInstance.m_22130_(mod.modifier());
            }
        });
        float afterMaxHealth = living.m_21233_();
        if (this.updateHealth() && afterMaxHealth != previousMaxHealth) {
            living.m_21153_(afterMaxHealth * previousHealthPercent);
        }
    }
}

