/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PreventItemActionPower
extends PowerFactory<FieldConfiguration<Optional<ConfiguredItemCondition<?, ?>>>> {
    public static boolean isUsagePrevented(Entity entity, ItemStack stack) {
        return IPowerContainer.getPowers(entity, (PreventItemActionPower)ApoliPowers.PREVENT_ITEM_USAGE.get()).stream().anyMatch(x -> ((PreventItemActionPower)((Object)((Object)x.getFactory()))).doesPrevent((ConfiguredPower<FieldConfiguration<Optional<ConfiguredItemCondition<?, ?>>>, ?>)x, entity.f_19853_, stack));
    }

    public static List<ConfiguredPower<FieldConfiguration<Optional<ConfiguredItemCondition<?, ?>>>, PreventItemActionPower>> getPreventingForDisplay(Entity entity, ItemStack stack) {
        return IPowerContainer.getPowers(entity, (PreventItemActionPower)ApoliPowers.PREVENT_ITEM_USAGE.get()).stream().filter(x -> ((PreventItemActionPower)((Object)((Object)x.getFactory()))).doesPrevent((ConfiguredPower<FieldConfiguration<Optional<ConfiguredItemCondition<?, ?>>>, ?>)x, entity.f_19853_, stack)).toList();
    }

    public PreventItemActionPower() {
        super(FieldConfiguration.optionalCodec(ConfiguredItemCondition.CODEC, "item_condition"));
    }

    public boolean doesPrevent(ConfiguredPower<FieldConfiguration<Optional<ConfiguredItemCondition<?, ?>>>, ?> configuration, Level level, ItemStack stack) {
        if (stack.m_41614_() && !ApoliAPI.enableFoodRestrictions()) {
            return false;
        }
        return configuration.getConfiguration().value().map(x -> x.check(level, stack)).orElse(true);
    }
}

