/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullSupplier;

public class PreventBlockActionPower
extends PowerFactory<FieldConfiguration<Optional<ConfiguredBlockCondition<?, ?>>>> {
    public static boolean isSelectionPrevented(Entity entity, BlockPos pos, NonNullSupplier<BlockState> stateGetter) {
        return IPowerContainer.getPowers(entity, (PreventBlockActionPower)ApoliPowers.PREVENT_BLOCK_SELECTION.get()).stream().anyMatch(x -> ((PreventBlockActionPower)((Object)((Object)x.getFactory()))).doesPrevent((ConfiguredPower<FieldConfiguration<Optional<ConfiguredBlockCondition<?, ?>>>, ?>)x, (LevelReader)entity.f_19853_, pos, stateGetter));
    }

    public static boolean isUsagePrevented(Entity entity, BlockPos pos) {
        return IPowerContainer.getPowers(entity, (PreventBlockActionPower)ApoliPowers.PREVENT_BLOCK_USAGE.get()).stream().anyMatch(x -> ((PreventBlockActionPower)((Object)((Object)x.getFactory()))).doesPrevent((ConfiguredPower<FieldConfiguration<Optional<ConfiguredBlockCondition<?, ?>>>, ?>)x, (LevelReader)entity.f_19853_, pos, (NonNullSupplier<BlockState>)((NonNullSupplier)() -> entity.f_19853_.m_8055_(pos))));
    }

    public PreventBlockActionPower() {
        super(FieldConfiguration.optionalCodec(ConfiguredBlockCondition.CODEC, "block_condition"));
    }

    public boolean doesPrevent(ConfiguredPower<FieldConfiguration<Optional<ConfiguredBlockCondition<?, ?>>>, ?> configuration, LevelReader reader, BlockPos position, NonNullSupplier<BlockState> stateGetter) {
        return ConfiguredBlockCondition.check(configuration.getConfiguration().value().orElse(null), reader, position, stateGetter);
    }
}

