/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.PhasingConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullSupplier;

public class PhasingPower
extends PowerFactory<PhasingConfiguration> {
    public static boolean shouldPhaseThrough(Entity entity, LevelReader reader, BlockPos pos, NonNullSupplier<BlockState> stateGetter, boolean isAbove) {
        return IPowerContainer.getPowers(entity, (PhasingPower)ApoliPowers.PHASING.get()).stream().anyMatch(x -> (!isAbove || ((PhasingConfiguration)x.getConfiguration()).canPhaseDown(entity)) && ((PhasingConfiguration)x.getConfiguration()).canPhaseThrough(reader, pos, stateGetter));
    }

    public static boolean shouldPhaseThrough(Entity entity, LevelReader reader, BlockPos pos, NonNullSupplier<BlockState> stateGetter) {
        return PhasingPower.shouldPhaseThrough(entity, reader, pos, stateGetter, false);
    }

    public static boolean shouldPhaseThrough(Entity entity, BlockPos pos) {
        return PhasingPower.shouldPhaseThrough(entity, (LevelReader)entity.f_19853_, pos, (NonNullSupplier<BlockState>)((NonNullSupplier)() -> entity.m_183503_().m_8055_(pos)));
    }

    public static boolean hasRenderMethod(Entity entity, PhasingConfiguration.RenderType renderType) {
        return IPowerContainer.getPowers(entity, (PhasingPower)ApoliPowers.PHASING.get()).stream().anyMatch(x -> renderType.equals((Object)((PhasingConfiguration)x.getConfiguration()).renderType()));
    }

    public static Optional<Float> getRenderMethod(Entity entity, PhasingConfiguration.RenderType renderType) {
        return IPowerContainer.getPowers(entity, (PhasingPower)ApoliPowers.PHASING.get()).stream().filter(x -> renderType.equals((Object)((PhasingConfiguration)x.getConfiguration()).renderType())).map(x -> Float.valueOf(((PhasingConfiguration)x.getConfiguration()).viewDistance())).min(Float::compareTo);
    }

    public PhasingPower() {
        super(PhasingConfiguration.CODEC);
    }
}

