/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.power.ValueModifyingPowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyHarvestConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;

public class ModifyHarvestPower
extends ValueModifyingPowerFactory<ModifyHarvestConfiguration> {
    public static Optional<Boolean> isHarvestAllowed(Player player, LevelReader reader, BlockPos pos) {
        return IPowerContainer.getPowers((Entity)player, (ModifyHarvestPower)ApoliPowers.MODIFY_HARVEST.get()).stream().filter(x -> ((ModifyHarvestPower)x.getFactory()).doesApply((ConfiguredPower<ModifyHarvestConfiguration, ?>)x, reader, pos)).map(x -> ((ModifyHarvestPower)x.getFactory()).isHarvestAllowed((ConfiguredPower<ModifyHarvestConfiguration, ?>)x)).reduce((x, y) -> x != false || y != false);
    }

    public ModifyHarvestPower() {
        super(ModifyHarvestConfiguration.CODEC);
    }

    public boolean doesApply(ConfiguredPower<ModifyHarvestConfiguration, ?> config, LevelReader reader, BlockPos pos) {
        return ConfiguredBlockCondition.check(config.getConfiguration().condition(), reader, pos);
    }

    public boolean isHarvestAllowed(ConfiguredPower<ModifyHarvestConfiguration, ?> config) {
        return config.getConfiguration().allow();
    }
}

