/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import com.google.common.collect.ImmutableList;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.AttributeModifyTransferConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeModifyTransferPower
extends PowerFactory<AttributeModifyTransferConfiguration> {
    public static List<AttributeModifier> apply(Entity entity, PowerFactory<?> power) {
        return IPowerContainer.getPowers(entity, (AttributeModifyTransferPower)ApoliPowers.ATTRIBUTE_MODIFY_TRANSFER.get()).stream().flatMap(cp -> ((AttributeModifyTransferPower)((Object)((Object)cp.getFactory()))).apply((ConfiguredPower<AttributeModifyTransferConfiguration, ?>)cp, entity, power).stream()).collect(Collectors.toList());
    }

    public AttributeModifyTransferPower() {
        super(AttributeModifyTransferConfiguration.CODEC);
    }

    public List<AttributeModifier> apply(ConfiguredPower<AttributeModifyTransferConfiguration, ?> power, Entity entity, PowerFactory<?> factory) {
        ImmutableList.Builder builder = ImmutableList.builder();
        AttributeModifyTransferConfiguration config = power.getConfiguration();
        if (entity instanceof LivingEntity) {
            AttributeInstance instance;
            AttributeMap attributes;
            LivingEntity living = (LivingEntity)entity;
            if (Objects.equals(config.target(), factory) && (attributes = living.m_21204_()).m_22171_(config.source()) && (instance = attributes.m_22146_(config.source())) != null) {
                instance.m_22122_().forEach(mod -> builder.add((Object)new AttributeModifier(mod.m_22209_(), mod.m_22214_(), mod.m_22218_() * config.multiplier(), mod.m_22217_())));
            }
        }
        return builder.build();
    }
}

