/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.network;

import io.github.apace100.apoli.Apoli;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CPlayerDismount(int entity) {
    public static S2CPlayerDismount decode(FriendlyByteBuf buffer) {
        return new S2CPlayerDismount(buffer.readInt());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entity());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleSync() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(this.entity());
        if (entity == null) {
            Apoli.LOGGER.warn("Unknown player tried to dismount");
        } else {
            Entity entity2 = entity.m_20202_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                player.m_6038_();
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleSync));
        contextSupplier.get().setPacketHandled(true);
    }
}

