/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.integration.PowerLoadEvent;
import io.github.apace100.calio.data.SerializableData;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.calio.api.registry.DynamicEntryFactory;
import io.github.edwinmindcraft.calio.api.registry.DynamicEntryValidator;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public enum PowerLoader implements DynamicEntryFactory<ConfiguredPower<?, ?>>,
DynamicEntryValidator<ConfiguredPower<?, ?>>
{
    INSTANCE;

    private static final Comparator<ConfiguredPower<?, ?>> LOADING_ORDER_COMPARATOR;

    @Override
    public ConfiguredPower<?, ?> accept(ResourceLocation resourceLocation, List<JsonElement> list) {
        SerializableData.CURRENT_NAMESPACE = resourceLocation.m_135827_();
        SerializableData.CURRENT_PATH = resourceLocation.m_135815_();
        Optional<ConfiguredPower<?, ?>> definition = list.stream().flatMap(x -> {
            PowerLoadEvent.Pre pre = new PowerLoadEvent.Pre(resourceLocation, (JsonElement)x);
            MinecraftForge.EVENT_BUS.post((Event)pre);
            if (pre.isCanceled()) {
                return Stream.empty();
            }
            DataResult power = ConfiguredPower.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)pre.getJson()).map(Pair::getFirst);
            Optional powerDefinition = power.resultOrPartial(error -> {});
            if (power.error().isPresent()) {
                if (powerDefinition.isEmpty()) {
                    Apoli.LOGGER.error("Error loading power \"{}\": {}", (Object)resourceLocation, (Object)((DataResult.PartialResult)power.error().get()).message());
                    return Stream.empty();
                }
                Apoli.LOGGER.warn("Power \"{}\" will only be partially loaded: {}", (Object)resourceLocation, (Object)((DataResult.PartialResult)power.error().get()).message());
            }
            powerDefinition.ifPresent(cp -> MinecraftForge.EVENT_BUS.post((Event)new PowerLoadEvent.Post(resourceLocation, (JsonElement)x, (ConfiguredPower<?, ?>)cp)));
            return powerDefinition.stream();
        }).max(LOADING_ORDER_COMPARATOR);
        SerializableData.CURRENT_NAMESPACE = null;
        SerializableData.CURRENT_PATH = null;
        if (definition.isEmpty()) {
            Apoli.LOGGER.error("Loading for all instances of power {} failed.", (Object)resourceLocation);
        }
        return definition.orElse(null);
    }

    @Override
    @NotNull
    public Map<ResourceLocation, ConfiguredPower<?, ?>> create(ResourceLocation location, @NotNull List<JsonElement> entries) {
        Object accept = this.accept(location, (List)entries);
        if (accept != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)location, ((ConfiguredPower)accept).complete(location));
            ((ConfiguredPower)accept).getContainedPowers().forEach((s, configuredPower) -> {
                ResourceLocation path = new ResourceLocation(location.m_135827_(), location.m_135815_() + s);
                builder.put((Object)path, configuredPower.complete(path));
            });
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @Override
    @NotNull
    public DataResult<ConfiguredPower<?, ?>> validate(@NotNull ResourceLocation location, @NotNull ConfiguredPower<?, ?> configuredPower, @NotNull ICalioDynamicRegistryManager manager) {
        if (!configuredPower.isConfigurationValid()) {
            configuredPower.getErrors(manager).forEach(x -> Apoli.LOGGER.error("Error in power {}: {}", (Object)location, x));
            return DataResult.error((String)"Invalid Configuration.");
        }
        return DataResult.success(configuredPower);
    }

    static {
        LOADING_ORDER_COMPARATOR = Comparator.comparingInt(x -> x.getData().loadingPriority());
    }
}

