/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.condition.entity;

import io.github.apace100.calio.data.SerializableDataType;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityCondition;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GameModeCondition
extends EntityCondition<FieldConfiguration<GameType>> {
    public GameModeCondition() {
        super(FieldConfiguration.codec(SerializableDataType.enumValue(GameType.class), "gamemode"));
    }

    protected boolean testClient(GameType mode, Entity entity) {
        return false;
    }

    @Override
    public boolean check(FieldConfiguration<GameType> configuration, Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayerGameMode interactionMngr = ((ServerPlayer)entity).f_8941_;
            return Objects.equals(interactionMngr.m_9290_(), configuration.value());
        }
        return this.testClient(configuration.value(), entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client
    extends GameModeCondition {
        @Override
        protected boolean testClient(GameType mode, Entity entity) {
            return entity instanceof LocalPlayer && Minecraft.m_91087_().f_91072_ != null && Objects.equals(Minecraft.m_91087_().f_91072_.m_105295_(), mode);
        }
    }
}

