/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.condition.bientity;

import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.BiEntityCondition;
import net.minecraft.world.entity.Entity;

public class DualBiEntityCondition
extends BiEntityCondition<FieldConfiguration<ConfiguredBiEntityCondition<?, ?>>> {
    private final Operator operator;

    public static DualBiEntityCondition invert() {
        return new DualBiEntityCondition((condition, actor, target) -> condition.check(target, actor));
    }

    public static DualBiEntityCondition undirected() {
        return new DualBiEntityCondition((condition, actor, target) -> condition.check(actor, target) || condition.check(target, actor));
    }

    private DualBiEntityCondition(Operator operator) {
        super(FieldConfiguration.codec(ConfiguredBiEntityCondition.CODEC, "condition"));
        this.operator = operator;
    }

    @Override
    protected boolean check(FieldConfiguration<ConfiguredBiEntityCondition<?, ?>> configuration, Entity actor, Entity target) {
        return this.operator.check(configuration.value(), actor, target);
    }

    @FunctionalInterface
    public static interface Operator {
        public boolean check(ConfiguredBiEntityCondition<?, ?> var1, Entity var2, Entity var3);
    }
}

