/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.util.GainedPowerCriterion;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.registry.ApoliCapabilities;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerContainer
implements IPowerContainer,
ICapabilitySerializable<Tag> {
    @NotNull
    private final LivingEntity owner;
    private final Map<ResourceLocation, ConfiguredPower<?, ?>> powers;
    private final Map<ResourceLocation, Set<ResourceLocation>> powerSources;
    private final Map<ResourceLocation, Object> powerData;
    private final transient LazyOptional<IPowerContainer> thisOptional = LazyOptional.of(() -> this);

    public PowerContainer(@NotNull LivingEntity owner) {
        this.owner = owner;
        this.powers = new ConcurrentHashMap();
        this.powerSources = new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>();
        this.powerData = new ConcurrentHashMap<ResourceLocation, Object>();
    }

    @Override
    public void removePower(ResourceLocation power, ResourceLocation source) {
        if (this.powerSources.containsKey(power)) {
            Set<ResourceLocation> sources = this.powerSources.get(power);
            sources.remove(source);
            ConfiguredPower<?, ?> instance = this.powers.get(power);
            if (sources.isEmpty()) {
                this.powerSources.remove(power);
                this.powers.remove(power);
                if (instance != null) {
                    instance.onRemoved((Entity)this.owner);
                    instance.onLost((Entity)this.owner);
                }
            }
            if (instance != null) {
                for (ConfiguredPower<?, ?> value : instance.getContainedPowers().values()) {
                    ResourceLocation id = value.getRegistryName();
                    if (id == null) continue;
                    this.removePower(id, source);
                }
            }
        }
    }

    @Override
    public int removeAllPowersFromSource(ResourceLocation source) {
        List<ResourceLocation> powersFromSource = this.getPowersFromSource(source);
        powersFromSource.forEach(power -> this.removePower((ResourceLocation)power, source));
        return powersFromSource.size();
    }

    @Override
    @NotNull
    public List<ResourceLocation> getPowersFromSource(ResourceLocation source) {
        return this.powerSources.entrySet().stream().filter(x -> ((Set)x.getValue()).contains(source)).map(Map.Entry::getKey).toList();
    }

    @Override
    public boolean addPower(ResourceLocation power, ResourceLocation source) {
        Registry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers(this.owner.m_20194_());
        Optional optionalInstance = powers.m_6612_(power);
        if (optionalInstance.isEmpty()) {
            Apoli.LOGGER.error("Trying to add unregistered power {} to entity {}", (Object)power, (Object)this.owner);
            return false;
        }
        ConfiguredPower instance = (ConfiguredPower)optionalInstance.get();
        if (this.powerSources.containsKey(power)) {
            Set<ResourceLocation> sources = this.powerSources.get(power);
            if (sources.contains(source)) {
                return false;
            }
            sources.add(source);
            for (ConfiguredPower<?, ?> value : instance.getContainedPowers().values()) {
                ResourceLocation id = value.getRegistryName();
                Apoli.LOGGER.info("Adding subpower {} from power {}", (Object)id, (Object)power);
                if (id == null) continue;
                this.addPower(id, source);
            }
            return true;
        }
        for (ConfiguredPower<?, ?> value : instance.getContainedPowers().values()) {
            ResourceLocation id = value.getRegistryName();
            Apoli.LOGGER.info("Adding subpower {} from power {}", (Object)id, (Object)power);
            if (id == null) continue;
            this.addPower(id, source);
        }
        HashSet sources = new HashSet();
        sources.add(source);
        this.powerSources.put(power, sources);
        this.powers.put(power, instance);
        instance.onGained((Entity)this.owner);
        instance.onAdded((Entity)this.owner);
        LivingEntity livingEntity = this.owner;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)livingEntity;
            GainedPowerCriterion.INSTANCE.trigger(spe, instance);
        }
        return true;
    }

    @Override
    public boolean hasPower(ResourceLocation power) {
        return this.powers.containsKey(power);
    }

    @Override
    public boolean hasPower(ResourceLocation power, ResourceLocation source) {
        return this.powerSources.containsKey(power) && this.powerSources.get(power).contains(source);
    }

    @Override
    @Nullable
    public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> ConfiguredPower<C, F> getPower(ResourceLocation power) {
        if (this.powers.containsKey(power)) {
            return this.powers.get(power);
        }
        return null;
    }

    @Override
    @NotNull
    public List<ConfiguredPower<?, ?>> getPowers() {
        return ImmutableList.copyOf(this.powers.values());
    }

    @Override
    @NotNull
    public Set<ResourceLocation> getPowerNames() {
        return ImmutableSet.copyOf(this.powers.keySet());
    }

    @Override
    @NotNull
    public Set<ResourceLocation> getPowerTypes(boolean includeSubPowers) {
        if (includeSubPowers) {
            return ImmutableSet.copyOf(this.powers.keySet());
        }
        Registry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers(this.owner.m_20194_());
        Set subPowers = this.powers.entrySet().stream().flatMap(x -> ((ConfiguredPower)x.getValue()).getChildren().stream().map(arg_0 -> ((Registry)powers).m_7981_(arg_0)).filter(Objects::nonNull)).collect(Collectors.toUnmodifiableSet());
        return this.powers.keySet().stream().filter(x -> !subPowers.contains(x)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NotNull
    public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> List<ConfiguredPower<C, F>> getPowers(F factory, boolean includeInactive) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.powers.values().stream().filter(value -> Objects.equals(factory, value.getFactory()) && (includeInactive || value.isActive((Entity)this.owner))).map(value -> value).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    @NotNull
    public List<ResourceLocation> getSources(ResourceLocation power) {
        return this.powerSources.containsKey(power) ? ImmutableList.copyOf((Collection)this.powerSources.get(power)) : ImmutableList.of();
    }

    @Override
    public void sync() {
        ApoliAPI.synchronizePowerContainer((Entity)this.owner);
    }

    @Override
    public void serverTick() {
        for (ConfiguredPower<?, ?> value : this.powers.values()) {
            value.tick((Entity)this.owner);
        }
    }

    @Override
    public void readNbt(CompoundTag tag, boolean applyEvents) {
        block15: {
            try {
                if (applyEvents) {
                    for (ConfiguredPower<?, ?> power : this.powers.values()) {
                        power.onRemoved((Entity)this.owner);
                        power.onLost((Entity)this.owner);
                    }
                }
                this.powers.clear();
                this.powerSources.clear();
                this.powerData.clear();
                ListTag powerList = (ListTag)tag.m_128423_("Powers");
                Registry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers();
                if (powerList == null) break block15;
                for (int i = 0; i < powerList.size(); ++i) {
                    CompoundTag powerTag = powerList.m_128728_(i);
                    ResourceLocation identifier = ResourceLocation.m_135820_((String)powerTag.m_128461_("Type"));
                    ListTag sources = (ListTag)powerTag.m_128423_("Sources");
                    HashSet list = new HashSet();
                    if (sources != null) {
                        sources.forEach(nbtElement -> list.add(ResourceLocation.m_135820_((String)nbtElement.m_7916_())));
                    }
                    this.powerSources.put(identifier, list);
                    try {
                        CompoundTag data = powerTag.m_128469_("Data");
                        Optional optionalPower = powers.m_6612_(identifier);
                        if (optionalPower.isEmpty()) {
                            Apoli.LOGGER.warn("Power data of unregistered power \"" + identifier + "\" found on entity, skipping...");
                            continue;
                        }
                        ConfiguredPower instance = (ConfiguredPower)optionalPower.get();
                        try {
                            instance.deserialize(this, data);
                        }
                        catch (ClassCastException e) {
                            Apoli.LOGGER.warn("Data type of \"" + identifier + "\" changed, skipping data for that power on entity " + this.owner.m_7755_().m_6111_());
                        }
                        this.powers.put(identifier, instance);
                        if (!applyEvents) continue;
                        instance.onAdded((Entity)this.owner);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Apoli.LOGGER.warn("Power data of unregistered power \"" + identifier + "\" found on entity, skipping...");
                    }
                }
                for (Map.Entry<ResourceLocation, Set<ResourceLocation>> entry : this.powerSources.entrySet()) {
                    ConfiguredPower power = (ConfiguredPower)powers.m_7745_(entry.getKey());
                    if (power == null) continue;
                    for (Map.Entry<String, ConfiguredPower<?, ?>> subPower : power.getContainedPowers().entrySet()) {
                        ResourceLocation sub = subPower.getValue().getRegistryName();
                        if (sub == null) {
                            Apoli.LOGGER.warn("Multiple power type read from data contained unregistered sub-type: \"" + entry.getKey() + subPower.getKey() + "\".");
                            continue;
                        }
                        for (ResourceLocation source : entry.getValue()) {
                            if (this.hasPower(sub, source)) continue;
                            this.addPower(sub, source);
                        }
                    }
                }
            }
            catch (Exception e) {
                Apoli.LOGGER.info("Error while reading data: " + e.getMessage());
            }
        }
    }

    @Override
    public void rebuildCache() {
        ImmutableSet powers = ImmutableSet.copyOf(this.powers.keySet());
        Registry<ConfiguredPower<?, ?>> registry = ApoliAPI.getPowers();
        for (ResourceLocation power : powers) {
            if (registry.m_7804_(power)) {
                this.powers.put(power, (ConfiguredPower)registry.m_7745_(power));
                continue;
            }
            this.powerSources.get(power).forEach(source -> this.removePower(power, (ResourceLocation)source));
            Apoli.LOGGER.warn("Power {} was removed from entity {} as it doesn't exist anymore.", (Object)power, (Object)this.owner.m_6302_());
        }
    }

    @Override
    public void handle(Multimap<ResourceLocation, ResourceLocation> powerSources, Map<ResourceLocation, CompoundTag> data) {
        this.powerSources.clear();
        this.powers.clear();
        this.powerData.clear();
        WritableRegistry<ConfiguredPower<?, ?>> powerRegistry = CalioAPI.getDynamicRegistries(this.owner.m_20194_()).get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
        for (Map.Entry powerEntry : powerSources.asMap().entrySet()) {
            ResourceLocation power = (ResourceLocation)powerEntry.getKey();
            ConfiguredPower configuredPower = (ConfiguredPower)powerRegistry.m_7745_(power);
            if (configuredPower == null) {
                Apoli.LOGGER.warn("Received missing power {} from server for entity {}", (Object)power, (Object)this.owner.m_6302_());
                continue;
            }
            this.powers.put(power, configuredPower);
            this.powerSources.put(power, new HashSet((Collection)powerEntry.getValue()));
            CompoundTag tag = data.get(power);
            if (tag == null) continue;
            configuredPower.deserialize(this, tag);
        }
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        ListTag powerList = new ListTag();
        for (Map.Entry<ResourceLocation, ConfiguredPower<?, ?>> powerEntry : this.powers.entrySet()) {
            CompoundTag powerTag = new CompoundTag();
            powerTag.m_128359_("Type", powerEntry.getKey().toString());
            powerTag.m_128365_("Data", (Tag)powerEntry.getValue().serialize(this));
            ListTag sources = new ListTag();
            this.powerSources.get(powerEntry.getKey()).forEach(id -> sources.add((Object)StringTag.m_129297_((String)id.toString())));
            powerTag.m_128365_("Sources", (Tag)sources);
            powerList.add((Object)powerTag);
        }
        tag.m_128365_("Powers", (Tag)powerList);
        return tag;
    }

    @Override
    @NotNull
    public <T> T getPowerData(ConfiguredPower<?, ?> power, NonNullSupplier<? extends T> supplier) {
        Object obj = this.powerData.computeIfAbsent(power.getRegistryName(), x -> supplier.get());
        try {
            return (T)obj;
        }
        catch (ClassCastException e) {
            return (T)this.powerData.put(power.getRegistryName(), supplier.get());
        }
    }

    @Override
    public Entity getOwner() {
        return this.owner;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ApoliCapabilities.POWER_CONTAINER.orEmpty(cap, this.thisOptional);
    }

    public Tag serializeNBT() {
        return this.writeToNbt(new CompoundTag());
    }

    public void deserializeNBT(Tag nbt) {
        this.readFromNbt((CompoundTag)nbt);
    }
}

