/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.action.meta;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.configuration.IStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IDelegatedActionConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;

public record StreamConfiguration<T, V>(List<T> entries, String name, BiConsumer<T, V> consumer) implements IDelegatedActionConfiguration<V>,
IStreamConfiguration<T>
{
    public static <T, V> StreamConfiguration<T, V> and(List<T> entries, BiConsumer<T, V> executor) {
        return new StreamConfiguration<T, V>(entries, "And", executor);
    }

    public static <C, A, V> StreamConfiguration<Pair<C, A>, V> ifElseList(List<Pair<C, A>> entries, BiPredicate<C, V> predicate, BiConsumer<A, V> executor) {
        BiConsumer<Pair, Object> consumer = (pair, v) -> {
            if (predicate.test(pair.getFirst(), v)) {
                executor.accept(pair.getSecond(), v);
            }
        };
        return new StreamConfiguration<Pair, Object>(entries, "IfElseList", consumer);
    }

    public static <T, V> Codec<StreamConfiguration<T, V>> and(Codec<T> source, BiConsumer<T, V> executor) {
        return CalioCodecHelper.listOf(source).fieldOf("actions").xmap(x -> StreamConfiguration.and(x, executor), StreamConfiguration::entries).codec();
    }

    public static <C, A, V> Codec<StreamConfiguration<Pair<C, A>, V>> ifElseList(Codec<C> condition, Codec<A> action, BiPredicate<C, V> predicate, BiConsumer<A, V> executor) {
        Codec pairCodec = RecordCodecBuilder.create(instance -> instance.group((App)condition.fieldOf("condition").forGetter(Pair::getFirst), (App)action.fieldOf("action").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
        return CalioCodecHelper.listOf(pairCodec).fieldOf("actions").xmap(x -> StreamConfiguration.ifElseList(x, predicate, executor), StreamConfiguration::entries).codec();
    }

    @Override
    public void execute(V parameters) {
        this.entries.forEach(t -> this.consumer.accept(t, parameters));
    }
}

