/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.action.entity;

import com.mojang.serialization.Codec;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityAction;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class FloatEntityAction
extends EntityAction<FieldConfiguration<Float>> {
    private final BiConsumer<Entity, Float> action;

    public static FloatEntityAction ofLiving(BiConsumer<LivingEntity, Float> action, String field) {
        return new FloatEntityAction((e, i) -> {
            if (e instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)e;
                action.accept(le, (Float)i);
            }
        }, field);
    }

    public static FloatEntityAction ofPlayer(BiConsumer<Player, Float> action, String field) {
        return new FloatEntityAction((e, i) -> {
            if (e instanceof Player) {
                Player le = (Player)e;
                action.accept(le, (Float)i);
            }
        }, field);
    }

    public FloatEntityAction(BiConsumer<Entity, Float> action, String field) {
        super(FieldConfiguration.codec(Codec.FLOAT, field));
        this.action = action;
    }

    @Override
    public void execute(FieldConfiguration<Float> configuration, Entity entity) {
        this.action.accept(entity, configuration.value());
    }
}

