/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.action.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.util.Shape;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.DoubleComparisonConfiguration;
import io.github.edwinmindcraft.apoli.common.action.configuration.ReferencePoint;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record DistanceFromPointConfiguration(ReferencePoint reference, Vec3 offset, boolean ignoreX, boolean ignoreY, boolean ignoreZ, Shape shape, boolean scaleReferenceToDimension, boolean scaleDistanceToDimension, DoubleComparisonConfiguration comparison, Optional<Boolean> resultOnWrongDimension, Optional<Integer> roundToDigit) implements IDynamicFeatureConfiguration
{
    public static final MapCodec<Vec3> OFFSET_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(SerializableDataTypes.VECTOR, "offset", Vec3.f_82478_).forGetter(Function.identity()), (App)CalioCodecHelper.optionalField(SerializableDataTypes.VECTOR, "coordinates", Vec3.f_82478_).forGetter(x -> Vec3.f_82478_)).apply((Applicative)instance, Vec3::m_82549_));

    public static Codec<DistanceFromPointConfiguration> codec(ReferencePoint reference) {
        return RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField(SerializableDataType.enumValue(ReferencePoint.class), "reference", reference).forGetter(DistanceFromPointConfiguration::reference), (App)OFFSET_CODEC.forGetter(DistanceFromPointConfiguration::offset), (App)CalioCodecHelper.optionalField(Codec.BOOL, "ignore_x", false).forGetter(DistanceFromPointConfiguration::ignoreX), (App)CalioCodecHelper.optionalField(Codec.BOOL, "ignore_y", false).forGetter(DistanceFromPointConfiguration::ignoreY), (App)CalioCodecHelper.optionalField(Codec.BOOL, "ignore_z", false).forGetter(DistanceFromPointConfiguration::ignoreZ), (App)CalioCodecHelper.optionalField(SerializableDataType.enumValue(Shape.class), "ignore_z", Shape.CUBE).forGetter(DistanceFromPointConfiguration::shape), (App)CalioCodecHelper.optionalField(Codec.BOOL, "scale_reference_to_dimension", true).forGetter(DistanceFromPointConfiguration::scaleReferenceToDimension), (App)CalioCodecHelper.optionalField(Codec.BOOL, "scale_distance_to_dimension", false).forGetter(DistanceFromPointConfiguration::scaleDistanceToDimension), (App)DoubleComparisonConfiguration.MAP_CODEC.forGetter(DistanceFromPointConfiguration::comparison), (App)CalioCodecHelper.optionalField(Codec.BOOL, "result_on_wrong_dimension").forGetter(DistanceFromPointConfiguration::resultOnWrongDimension), (App)CalioCodecHelper.optionalField(Codec.INT, "round_to_digit").forGetter(DistanceFromPointConfiguration::roundToDigit)).apply((Applicative)instance, DistanceFromPointConfiguration::new));
    }

    public boolean test(@Nullable Entity entity, Vec3 position, Level level) {
        double scale = level.m_6042_().m_63959_();
        Vec3 point = this.reference().getPoint(entity, level, this.resultOnWrongDimension().isPresent());
        if (point == null) {
            return this.resultOnWrongDimension().get();
        }
        point = point.m_82549_(this.offset());
        if (this.scaleReferenceToDimension() && (point.m_7096_() != 0.0 || point.m_7094_() != 0.0)) {
            if (scale == 0.0) {
                return this.comparison().check(Double.POSITIVE_INFINITY);
            }
            point = point.m_82542_(1.0 / scale, 1.0, 1.0 / scale);
        }
        Vec3 delta = point.m_82546_(position);
        delta = new Vec3(this.ignoreX() ? 0.0 : Math.abs(delta.m_7096_()), this.ignoreY() ? 0.0 : Math.abs(delta.m_7098_()), this.ignoreZ() ? 0.0 : Math.abs(delta.m_7094_()));
        if (this.scaleDistanceToDimension()) {
            delta.m_82542_(scale, 1.0, scale);
        }
        double distance = Shape.getDistance(this.shape(), delta.m_7096_(), delta.m_7098_(), delta.m_7094_());
        if (this.roundToDigit().isPresent()) {
            distance = new BigDecimal(distance).setScale((int)this.roundToDigit().get(), RoundingMode.HALF_UP).doubleValue();
        }
        return this.comparison().check(distance);
    }
}

