/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.action.configuration;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.ResourceOperation;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record ChangeResourceConfiguration(ResourceLocation resource, int amount, ResourceOperation operation) implements IDynamicFeatureConfiguration
{
    public static final Codec<ChangeResourceConfiguration> ANY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.IDENTIFIER.fieldOf("resource").forGetter(ChangeResourceConfiguration::resource), (App)Codec.INT.fieldOf("change").forGetter(ChangeResourceConfiguration::amount), (App)CalioCodecHelper.optionalField(ApoliDataTypes.RESOURCE_OPERATION, "operation", ResourceOperation.ADD).forGetter(ChangeResourceConfiguration::operation)).apply((Applicative)instance, ChangeResourceConfiguration::new));
    public static final Codec<ChangeResourceConfiguration> SET_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.IDENTIFIER.fieldOf("resource").forGetter(ChangeResourceConfiguration::resource), (App)Codec.INT.fieldOf("value").forGetter(ChangeResourceConfiguration::amount)).apply((Applicative)instance, (resource, amount) -> new ChangeResourceConfiguration((ResourceLocation)resource, (int)amount, ResourceOperation.SET)));

    @Override
    @NotNull
    public List<String> getErrors(@NotNull ICalioDynamicRegistryManager server) {
        return this.checkPower(server, this.resource()).stream().map(x -> "Missing power: %s".formatted(x.toString())).toList();
    }

    @Override
    @NotNull
    public List<String> getWarnings(@NotNull ICalioDynamicRegistryManager server) {
        if (this.amount() == 0 && this.operation() == ResourceOperation.ADD) {
            return ImmutableList.of((Object)"Change expected, was 0");
        }
        return ImmutableList.of();
    }

    @Override
    public boolean isConfigurationValid() {
        return this.amount() != 0;
    }
}

