/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.util.ApoliConfigs;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.edwinmindcraft.apoli.api.VariableAccess;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.component.IPowerDataCache;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.InteractionPowerConfiguration;
import io.github.edwinmindcraft.apoli.common.power.ActionOnBeingUsedPower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnBlockBreakPower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnBlockUsePower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnEntityUsePower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnItemUsePower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnLandPower;
import io.github.edwinmindcraft.apoli.common.power.ActionOnWakeUpPower;
import io.github.edwinmindcraft.apoli.common.power.AttackerActionWhenHitPower;
import io.github.edwinmindcraft.apoli.common.power.CombatHitActionPower;
import io.github.edwinmindcraft.apoli.common.power.EffectImmunityPower;
import io.github.edwinmindcraft.apoli.common.power.InventoryPower;
import io.github.edwinmindcraft.apoli.common.power.InvulnerablePower;
import io.github.edwinmindcraft.apoli.common.power.KeepInventoryPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyDamageDealtPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyDamageTakenPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyFallingPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyJumpPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValueBlockPower;
import io.github.edwinmindcraft.apoli.common.power.PreventBlockActionPower;
import io.github.edwinmindcraft.apoli.common.power.PreventDeathPower;
import io.github.edwinmindcraft.apoli.common.power.PreventGameEventPower;
import io.github.edwinmindcraft.apoli.common.power.PreventItemActionPower;
import io.github.edwinmindcraft.apoli.common.power.PreventSleepPower;
import io.github.edwinmindcraft.apoli.common.power.RestrictArmorPower;
import io.github.edwinmindcraft.apoli.common.power.SelfActionWhenHitPower;
import io.github.edwinmindcraft.apoli.common.power.SelfCombatActionPower;
import io.github.edwinmindcraft.apoli.common.power.TargetCombatActionPower;
import io.github.edwinmindcraft.apoli.common.power.TooltipPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.InventoryConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.KeepInventoryConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyFallingConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyValueBlockConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="apoli")
public class ApoliPowerEventHandler {
    @SubscribeEvent
    public static void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getPlayer();
        Level world = player.m_20193_();
        float hardness = event.getState().m_60800_((BlockGetter)world, event.getPos());
        if (hardness <= 0.0f) {
            return;
        }
        float speed = event.getNewSpeed();
        boolean stateCheck = event.getState().canHarvestBlock((BlockGetter)event.getPlayer().m_183503_(), event.getPos(), event.getPlayer());
        boolean forgeCheck = ForgeHooks.isCorrectToolForDrops((BlockState)event.getState(), (Player)event.getPlayer());
        int toolFactor = forgeCheck ? 30 : 100;
        float factor = hardness * (float)toolFactor;
        speed = IPowerContainer.modify((Entity)player, (ModifyValueBlockPower)ApoliPowers.MODIFY_BREAK_SPEED.get(), speed / factor, p -> ConfiguredBlockCondition.check(((ModifyValueBlockConfiguration)p.getConfiguration()).condition(), (LevelReader)world, event.getPos(), (NonNullSupplier<BlockState>)((NonNullSupplier)() -> ((PlayerEvent.BreakSpeed)event).getState()))) * factor;
        if (stateCheck == forgeCheck) {
            event.setNewSpeed(speed);
        } else if (stateCheck) {
            event.setNewSpeed(speed * 3.3333333f);
        } else {
            event.setNewSpeed(speed * 0.3f);
        }
        if (speed <= 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSleep(PlayerSleepInBedEvent event) {
        if (PreventSleepPower.tryPreventSleep(event.getPlayer(), event.getPlayer().m_20193_(), event.getPos())) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public static void onWakeUp(PlayerWakeUpEvent event) {
        event.getPlayer().m_21257_().ifPresent(pos -> ActionOnWakeUpPower.execute((Entity)event.getEntityLiving(), pos));
    }

    @SubscribeEvent
    public static void finishUsing(LivingEntityUseItemEvent.Finish event) {
        ActionOnItemUsePower.execute((Entity)event.getEntityLiving(), event.getItem(), new VariableAccess<ItemStack>(() -> ((LivingEntityUseItemEvent.Finish)event).getResultStack(), arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0)));
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            ActionOnBlockBreakPower.execute((Entity)event.getPlayer(), (LevelReader)event.getWorld(), event.getPos(), (NonNullSupplier<BlockState>)((NonNullSupplier)() -> ((BlockEvent.BreakEvent)event).getState()), !event.isCanceled());
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        LivingEntity entityLiving = event.getEntityLiving();
        ActionOnLandPower.execute((Entity)entityLiving);
        if (IPowerContainer.getPowers((Entity)entityLiving, (ModifyFallingPower)ApoliPowers.MODIFY_FALLING.get()).stream().anyMatch(x -> !((ModifyFallingConfiguration)x.getConfiguration()).takeFallDamage())) {
            event.setDamageMultiplier(0.0f);
        }
    }

    @SubscribeEvent
    public static void modifyDamageTaken(LivingDamageEvent event) {
        LivingEntity entityLiving = event.getEntityLiving();
        event.setAmount(ModifyDamageTakenPower.modify((Entity)entityLiving, event.getSource(), event.getAmount()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void livingDamage(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        IPowerDataCache.get(target).ifPresent(x -> x.setDamage(amount));
        if (source.m_19360_()) {
            event.setAmount(ModifyDamageDealtPower.modifyProjectileNoExec(source.m_7639_(), (Entity)target, source, amount));
        } else {
            event.setAmount(ModifyDamageDealtPower.modifyMeleeNoExec(source.m_7639_(), (Entity)target, source, amount));
        }
        if (event.getAmount() != amount && event.getAmount() <= 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void livingAttack(LivingAttackEvent event) {
        LivingEntity target = event.getEntityLiving();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        IPowerDataCache.get(target).ifPresent(x -> x.setDamage(amount));
        float newAmount = source.m_19360_() ? ModifyDamageDealtPower.modifyProjectile(source.m_7639_(), (Entity)target, source, amount) : ModifyDamageDealtPower.modifyMelee(source.m_7639_(), (Entity)target, source, amount);
        if (newAmount != amount && newAmount <= 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void livingJump(LivingEvent.LivingJumpEvent event) {
        double modified = ModifyJumpPower.apply((Entity)event.getEntityLiving(), event.getEntityLiving().m_20184_().f_82480_);
        ApoliPowerEventHandler.updateJumpHeight(modified, event.getEntityLiving());
    }

    private static void updateJumpHeight(double height, LivingEntity entity) {
        Vec3 vel = entity.m_20184_();
        double delta = height - vel.f_82480_;
        if (delta == 0.0) {
            return;
        }
        entity.m_20256_(vel.m_82520_(0.0, delta, 0.0));
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (event.getAmount() > 0.0f && !event.isCanceled()) {
            SelfActionWhenHitPower.execute((Entity)target, source, event.getAmount());
            AttackerActionWhenHitPower.execute((Entity)target, source, event.getAmount());
            if (attacker != null) {
                SelfCombatActionPower.onHit(attacker, (Entity)target, source, event.getAmount());
                TargetCombatActionPower.onHit(attacker, (Entity)target, source, event.getAmount());
                CombatHitActionPower.perform(attacker, (Entity)target, source, event.getAmount());
            }
        }
        IPowerDataCache.get(target).ifPresent(x -> x.setDamage(event.getAmount()));
    }

    @SubscribeEvent
    public static void onLivingKilled(LivingDeathEvent event) {
        IPowerDataCache.get(event.getEntityLiving()).map(IPowerDataCache::getDamage).ifPresent(x -> {
            Entity patt8660$temp = event.getSource().m_7639_();
            if (patt8660$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt8660$temp;
                SelfCombatActionPower.onKill((Entity)living, (Entity)event.getEntityLiving(), event.getSource(), x.floatValue());
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                IPowerContainer.getPowers((Entity)player, (InventoryPower)ApoliPowers.INVENTORY.get()).forEach(inventory -> {
                    if (((InventoryPower)inventory.getFactory()).shouldDropOnDeath((ConfiguredPower<InventoryConfiguration, ?>)inventory, (Entity)player)) {
                        Container container = ((InventoryPower)inventory.getFactory()).getInventory((ConfiguredPower<InventoryConfiguration, ?>)inventory, (Entity)player);
                        for (int i = 0; i < container.m_6643_(); ++i) {
                            ItemStack itemStack = container.m_8020_(i);
                            if (!((InventoryPower)inventory.getFactory()).shouldDropOnDeath((ConfiguredPower<InventoryConfiguration, ?>)inventory, (Entity)player, itemStack)) continue;
                            if (!itemStack.m_41619_() && EnchantmentHelper.m_44924_((ItemStack)itemStack)) {
                                container.m_8016_(i);
                                continue;
                            }
                            player.m_7197_(itemStack, true, false);
                            container.m_6836_(i, ItemStack.f_41583_);
                        }
                    }
                });
                IPowerContainer.getPowers((Entity)player, (KeepInventoryPower)ApoliPowers.KEEP_INVENTORY.get()).forEach(power -> ((KeepInventoryPower)((Object)((Object)power.getFactory()))).captureItems((ConfiguredPower<KeepInventoryConfiguration, ?>)power, player));
            }
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        List tooltips = event.getToolTip();
        if (((Boolean)ApoliConfigs.CLIENT.tooltips.showUsabilityHints.get()).booleanValue()) {
            ArrayList powers = new ArrayList(PreventItemActionPower.getPreventingForDisplay(event.getEntity(), event.getItemStack()));
            int size = powers.size();
            if (!powers.isEmpty()) {
                powers.removeIf(x -> x.getData().hidden());
                String key = "tooltip.apoli.unusable." + event.getItemStack().m_41780_().name().toLowerCase(Locale.ROOT);
                ChatFormatting textColor = ChatFormatting.GRAY;
                ChatFormatting powerColor = ChatFormatting.RED;
                if (((Boolean)ApoliConfigs.CLIENT.tooltips.compactUsabilityHints.get()).booleanValue() || powers.size() == 0) {
                    if (powers.size() == 1) {
                        ConfiguredPower power = (ConfiguredPower)powers.get(0);
                        tooltips.add(new TranslatableComponent(key + ".single", new Object[]{power.getData().getName().m_130940_(powerColor)}).m_130940_(textColor));
                    } else {
                        tooltips.add(new TranslatableComponent(key + ".multiple", new Object[]{new TextComponent("" + (powers.size() == 0 ? size : powers.size())).m_130940_(powerColor)}).m_130940_(textColor));
                    }
                } else {
                    MutableComponent powerNameList = ((ConfiguredPower)powers.get(0)).getData().getName().m_130940_(powerColor);
                    for (int i = 1; i < powers.size(); ++i) {
                        powerNameList = powerNameList.m_7220_((Component)new TextComponent(", ").m_130940_(textColor));
                        powerNameList = powerNameList.m_7220_((Component)((ConfiguredPower)powers.get(i)).getData().getName().m_130940_(powerColor));
                    }
                    MutableComponent preventText = new TranslatableComponent(key + ".single", new Object[]{powerNameList}).m_130940_(textColor);
                    tooltips.add(preventText);
                }
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(event.getItemStack(), slot).stream().filter(sp -> !sp.isHidden).toList();
            if (powers.size() <= 0) continue;
            tooltips.add(TextComponent.f_131282_);
            tooltips.add(new TranslatableComponent("item.modifiers." + slot.m_20751_()).m_130940_(ChatFormatting.GRAY));
            powers.forEach(sp -> {
                if (PowerTypeRegistry.contains(sp.powerId)) {
                    PowerType<?> powerType = PowerTypeRegistry.get(sp.powerId);
                    tooltips.add(new TextComponent(" ").m_7220_((Component)powerType.getName()).m_130940_(sp.isNegative ? ChatFormatting.RED : ChatFormatting.BLUE));
                    if (event.getFlags().m_7050_()) {
                        tooltips.add(new TextComponent("  ").m_7220_((Component)powerType.getDescription()).m_130940_(ChatFormatting.GRAY));
                    }
                }
            });
        }
        TooltipPower.tryAdd(event.getEntity(), event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void playerEntityInteraction(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getPlayer();
        if (player.m_5833_()) {
            return;
        }
        Entity target = event.getTarget();
        Optional<InteractionResult> result = Stream.concat(ActionOnEntityUsePower.tryInteract((Entity)player, target, event.getHand()).stream(), ActionOnBeingUsedPower.tryInteract(target, (Entity)player, event.getHand()).stream()).reduce(InteractionPowerConfiguration::reduce);
        result.ifPresent(res -> {
            event.setCancellationResult(res);
            event.setCanceled(true);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void playerBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        ActionOnBlockUsePower.tryInteract(event.getEntity(), event.getPos(), event.getFace(), event.getHand()).ifPresent(res -> {
            event.setCancellationResult(res);
            event.setCanceled(true);
        });
    }

    @SubscribeEvent
    public static void preventPotionEffect(PotionEvent.PotionApplicableEvent event) {
        if (EffectImmunityPower.isImmune(event.getEntity(), event.getPotionEffect())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventGameEvent(VanillaGameEvent event) {
        if (PreventGameEventPower.tryPreventGameEvent(event.getCause(), event.getVanillaEvent())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void makeInvulnerable(LivingAttackEvent event) {
        LivingEntity entityLiving = event.getEntityLiving();
        if (InvulnerablePower.isInvulnerableTo((Entity)entityLiving, event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventLivingDeath(LivingDeathEvent event) {
        IPowerDataCache.get(event.getEntityLiving()).map(IPowerDataCache::getDamage).ifPresent(x -> {
            if (PreventDeathPower.tryPreventDeath((Entity)event.getEntityLiving(), event.getSource(), x.floatValue())) {
                event.getEntityLiving().m_21153_(1.0f);
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventEntityInteraction(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getPlayer();
        if (player.m_5833_()) {
            return;
        }
        Entity target = event.getTarget();
        ActionOnEntityUsePower.tryPrevent((Entity)player, target, event.getHand()).or(() -> ActionOnBeingUsedPower.tryPrevent(target, (Entity)player, event.getHand())).ifPresent(res -> {
            event.setCancellationResult(res);
            event.setCanceled(true);
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        if (PreventBlockActionPower.isUsagePrevented((Entity)event.getPlayer(), event.getPos())) {
            event.setUseBlock(Event.Result.DENY);
        }
        if (!(event.getItemStack().m_41720_() instanceof BlockItem) && PreventItemActionPower.isUsagePrevented((Entity)event.getPlayer(), event.getItemStack())) {
            event.setUseItem(Event.Result.DENY);
        }
        if (event.getItemStack().m_41720_() instanceof ArmorItem) {
            EquipmentSlot slot = Mob.m_147233_((ItemStack)event.getItemStack());
            if (RestrictArmorPower.isForbidden((Entity)event.getPlayer(), slot, event.getItemStack())) {
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventItemUsage(PlayerInteractEvent.RightClickItem event) {
        if (PreventItemActionPower.isUsagePrevented((Entity)event.getPlayer(), event.getItemStack())) {
            event.setCanceled(true);
        }
        if (event.getItemStack().m_41720_() instanceof ArmorItem) {
            EquipmentSlot slot = Mob.m_147233_((ItemStack)event.getItemStack());
            if (RestrictArmorPower.isForbidden((Entity)event.getPlayer(), slot, event.getItemStack())) {
                event.setCanceled(true);
            }
        }
    }
}

