/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.calio.Calio;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.InvisibilityPower;
import io.github.edwinmindcraft.apoli.common.power.ParticlePower;
import io.github.edwinmindcraft.apoli.common.power.PhasingPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.PhasingConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.util.CoreUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="apoli", value={Dist.CLIENT})
public class ApoliClientEventHandler {
    private static final HashMap<String, KeyMapping> idToKeyBindingMap = new HashMap();
    private static final HashMap<String, Boolean> lastKeyBindingStates = new HashMap();
    private static boolean initializedKeyBindingMap = false;

    public static void registerPowerKeybinding(String keyId, KeyMapping keyBinding) {
        idToKeyBindingMap.put(keyId, keyBinding);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockOverlay(RenderBlockOverlayEvent event) {
        if (event.getPlayer() != null && IPowerContainer.hasPower((Entity)event.getPlayer(), (PhasingPower)ApoliPowers.PHASING.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingRender(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        if (InvisibilityPower.isArmorHidden((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            boolean firstPerson = Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
            if (!event.getEntity().m_20177_((Player)player)) {
                ParticlePower.renderParticles(event.getEntity(), (Entity)player, firstPerson);
            }
        }
    }

    private static KeyMapping getKeyBinding(String key) {
        if (!idToKeyBindingMap.containsKey(key)) {
            if (!initializedKeyBindingMap) {
                initializedKeyBindingMap = true;
                Minecraft client = Minecraft.m_91087_();
                for (int i = 0; i < client.f_91066_.f_92059_.length; ++i) {
                    idToKeyBindingMap.put(client.f_91066_.f_92059_[i].m_90860_(), client.f_91066_.f_92059_[i]);
                }
                return ApoliClientEventHandler.getKeyBinding(key);
            }
            return null;
        }
        return idToKeyBindingMap.get(key);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft instance = Minecraft.m_91087_();
            LocalPlayer player = instance.f_91074_;
            if (player != null) {
                IPowerContainer.get((Entity)player).ifPresent(container -> {
                    HashMap currentKeyBindingStates = new HashMap();
                    HashSet<ResourceLocation> pressedPowers = new HashSet<ResourceLocation>();
                    Registry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers();
                    for (ConfiguredPower<?, ?> power : container.getPowers()) {
                        power.getKey((Entity)player).ifPresent(key -> {
                            KeyMapping binding = ApoliClientEventHandler.getKeyBinding(key.key());
                            if (binding != null) {
                                if (!currentKeyBindingStates.containsKey(key.key())) {
                                    currentKeyBindingStates.put(key.key(), binding.m_90857_());
                                }
                                if (((Boolean)currentKeyBindingStates.get(key.key())).booleanValue() && (key.continuous() || !lastKeyBindingStates.getOrDefault(key.key(), false).booleanValue())) {
                                    pressedPowers.add(powers.m_7981_((Object)power));
                                }
                            } else if (Calio.isDebugMode()) {
                                Apoli.LOGGER.warn("No such key: {}", (Object)key.key());
                            }
                        });
                    }
                    lastKeyBindingStates.clear();
                    lastKeyBindingStates.putAll(currentKeyBindingStates);
                    if (pressedPowers.size() > 0) {
                        ApoliAPI.performPowers(pressedPowers);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void renderFog(EntityViewRenderEvent.RenderFogEvent event) {
        LivingEntity living;
        Optional<Float> renderMethod;
        float start = RenderSystem.m_157200_();
        float end = RenderSystem.m_157199_();
        FogRenderer.FogMode mode = event.getMode();
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity && (renderMethod = PhasingPower.getRenderMethod((Entity)(living = (LivingEntity)entity), PhasingConfiguration.RenderType.BLINDNESS)).isPresent() && CoreUtils.getInWallBlockState(living) != null) {
            float v;
            float s;
            float view = renderMethod.get().floatValue();
            if (mode == FogRenderer.FogMode.FOG_SKY) {
                s = Math.min(0.0f, start);
                v = Math.min(view * 0.8f, end);
            } else {
                s = Math.min(view * 0.25f, start);
                v = Math.min(view, end);
            }
            RenderSystem.m_157445_((float)s);
            RenderSystem.m_157443_((float)v);
        }
    }

    @SubscribeEvent
    public static void fogColor(EntityViewRenderEvent.FogColors event) {
        LivingEntity living;
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity && PhasingPower.hasRenderMethod((Entity)(living = (LivingEntity)entity), PhasingConfiguration.RenderType.BLINDNESS) && CoreUtils.getInWallBlockState(living) != null) {
            event.setBlue(0.0f);
            event.setGreen(0.0f);
            event.setRed(0.0f);
        }
    }
}

