/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.factory.power;

import com.mojang.serialization.Codec;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.ITogglePower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.TogglePowerConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public abstract class TogglePowerFactory<T extends TogglePowerConfiguration>
extends PowerFactory<T>
implements ITogglePower<T> {
    protected TogglePowerFactory(Codec<T> codec) {
        super(codec);
    }

    protected TogglePowerFactory(Codec<T> codec, boolean allowConditions) {
        super(codec, allowConditions);
    }

    protected void setStatus(ConfiguredPower<T, ?> configuration, Entity entity, boolean status) {
        this.setStatus(configuration, (IPowerContainer)IPowerContainer.get(entity).resolve().orElse(null), status);
    }

    protected boolean getStatus(ConfiguredPower<T, ?> configuration, Entity entity) {
        return this.getStatus(configuration, (IPowerContainer)IPowerContainer.get(entity).resolve().orElse(null));
    }

    protected abstract void setStatus(ConfiguredPower<T, ?> var1, @Nullable IPowerContainer var2, boolean var3);

    protected abstract boolean getStatus(ConfiguredPower<T, ?> var1, @Nullable IPowerContainer var2);

    @Override
    public boolean isActive(ConfiguredPower<T, ?> configuration, Entity player) {
        return super.isActive(configuration, player) && this.getStatus(configuration, player);
    }

    @Override
    protected boolean shouldTickWhenActive(ConfiguredPower<T, ?> configuration, Entity entity) {
        return !((TogglePowerConfiguration)configuration.getConfiguration()).retainState() && configuration.getData().conditions().size() > 0;
    }

    @Override
    protected boolean shouldTickWhenInactive(ConfiguredPower<T, ?> configuration, Entity entity) {
        return true;
    }

    @Override
    public void tick(ConfiguredPower<T, ?> configuration, Entity entity) {
        if (!super.isActive(configuration, entity) && this.getStatus(configuration, entity)) {
            this.setStatus(configuration, entity, false);
            IPowerContainer.sync(entity);
        }
    }

    @Override
    public void activate(ConfiguredPower<T, ?> configuration, Entity player) {
        this.toggle(configuration, player);
    }

    @Override
    public void toggle(ConfiguredPower<T, ?> configuration, Entity entity) {
        this.setStatus(configuration, entity, !this.getStatus(configuration, entity));
        IPowerContainer.sync(entity);
    }

    @Override
    public IActivePower.Key getKey(ConfiguredPower<T, ?> configuration, @Nullable Entity player) {
        return ((TogglePowerConfiguration)configuration.getConfiguration()).key();
    }

    public static abstract class Simple<T extends TogglePowerConfiguration>
    extends TogglePowerFactory<T> {
        protected Simple(Codec<T> codec) {
            super(codec);
        }

        protected Simple(Codec<T> codec, boolean allowConditions) {
            super(codec, allowConditions);
        }

        private AtomicBoolean getData(ConfiguredPower<T, ?> configuration, IPowerContainer container) {
            return (AtomicBoolean)configuration.getPowerData(container, () -> new AtomicBoolean(((TogglePowerConfiguration)configuration.getConfiguration()).defaultState()));
        }

        @Override
        protected void setStatus(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container, boolean status) {
            if (container == null) {
                return;
            }
            this.getData(configuration, container).set(status);
        }

        @Override
        protected boolean getStatus(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container) {
            if (container == null) {
                return false;
            }
            return this.getData(configuration, container).get();
        }

        @Override
        public void serialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            tag.m_128379_("Status", this.getStatus(configuration, container));
        }

        @Override
        public void deserialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            this.setStatus(configuration, container, tag.m_128471_("Status"));
        }
    }
}

