/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.factory.power;

import com.mojang.serialization.Codec;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.IActiveCooldownPowerConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.power.CooldownPowerFactory;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public abstract class ActiveCooldownPowerFactory<T extends IActiveCooldownPowerConfiguration>
extends CooldownPowerFactory<T>
implements IActivePower<T> {
    protected ActiveCooldownPowerFactory(Codec<T> codec) {
        super(codec);
    }

    protected ActiveCooldownPowerFactory(Codec<T> codec, boolean allowConditions) {
        super(codec, allowConditions);
    }

    protected abstract void execute(ConfiguredPower<T, ?> var1, Entity var2);

    @Override
    public void activate(ConfiguredPower<T, ?> configuration, Entity player) {
        if (this.canUse(configuration, player)) {
            this.execute(configuration, player);
            this.use(configuration, player);
        }
    }

    @Override
    public IActivePower.Key getKey(ConfiguredPower<T, ?> configuration, @Nullable Entity player) {
        return ((IActiveCooldownPowerConfiguration)configuration.getConfiguration()).key();
    }

    public static abstract class Simple<T extends IActiveCooldownPowerConfiguration>
    extends ActiveCooldownPowerFactory<T> {
        protected Simple(Codec<T> codec) {
            super(codec);
        }

        protected Simple(Codec<T> codec, boolean allowConditions) {
            super(codec, allowConditions);
        }

        protected AtomicLong getUseTime(ConfiguredPower<T, ?> configuration, IPowerContainer container) {
            return (AtomicLong)configuration.getPowerData(container, () -> new AtomicLong(Long.MIN_VALUE));
        }

        @Override
        protected long getLastUseTime(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container) {
            if (container == null) {
                return 0L;
            }
            return this.getUseTime(configuration, container).get();
        }

        @Override
        protected void setLastUseTime(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container, long value) {
            if (container == null) {
                return;
            }
            this.getUseTime(configuration, container).set(value);
        }

        @Override
        public void serialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            tag.m_128356_("LastUseTime", this.getLastUseTime(configuration, container));
        }

        @Override
        public void deserialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            this.setLastUseTime(configuration, container, tag.m_128454_("LastUseTime"));
        }
    }
}

