/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.configuration.power;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.VariableAccess;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public record InteractionPowerConfiguration(EnumSet<InteractionHand> hands, InteractionResult actionResult, @Nullable ConfiguredItemCondition<?, ?> itemCondition, @Nullable ConfiguredItemAction<?, ?> heldItemAction, @Nullable ItemStack itemResult, @Nullable ConfiguredItemAction<?, ?> resultItemAction) {
    public static final MapCodec<InteractionPowerConfiguration> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(SerializableDataTypes.HAND_SET, "hands", () -> EnumSet.allOf(InteractionHand.class)).forGetter(InteractionPowerConfiguration::hands), (App)CalioCodecHelper.optionalField(SerializableDataTypes.ACTION_RESULT, "action_result", InteractionResult.SUCCESS).forGetter(InteractionPowerConfiguration::actionResult), (App)CalioCodecHelper.optionalField(ConfiguredItemCondition.CODEC, "item_condition").forGetter(x -> Optional.ofNullable(x.itemCondition())), (App)CalioCodecHelper.optionalField(ConfiguredItemAction.CODEC, "held_item_action").forGetter(x -> Optional.ofNullable(x.heldItemAction())), (App)CalioCodecHelper.optionalField(SerializableDataTypes.ITEM_STACK, "result_stack").forGetter(x -> Optional.ofNullable(x.itemResult())), (App)CalioCodecHelper.optionalField(ConfiguredItemAction.CODEC, "result_item_action").forGetter(x -> Optional.ofNullable(x.resultItemAction()))).apply((Applicative)instance, (t1, t2, t3, t4, t5, t6) -> new InteractionPowerConfiguration((EnumSet<InteractionHand>)t1, (InteractionResult)t2, t3.orElse(null), t4.orElse(null), t5.orElse(null), t6.orElse(null))));
    public static final MapCodec<InteractionPowerConfiguration> PREVENTING_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(SerializableDataTypes.HAND_SET, "hands", () -> EnumSet.allOf(InteractionHand.class)).forGetter(InteractionPowerConfiguration::hands), (App)CalioCodecHelper.optionalField(ConfiguredItemCondition.CODEC, "item_condition").forGetter(x -> Optional.ofNullable(x.itemCondition())), (App)CalioCodecHelper.optionalField(ConfiguredItemAction.CODEC, "held_item_action").forGetter(x -> Optional.ofNullable(x.heldItemAction())), (App)CalioCodecHelper.optionalField(SerializableDataTypes.ITEM_STACK, "result_stack").forGetter(x -> Optional.ofNullable(x.itemResult())), (App)CalioCodecHelper.optionalField(ConfiguredItemAction.CODEC, "result_item_action").forGetter(x -> Optional.ofNullable(x.resultItemAction()))).apply((Applicative)instance, (t1, t3, t4, t5, t6) -> new InteractionPowerConfiguration((EnumSet<InteractionHand>)t1, InteractionResult.FAIL, t3.orElse(null), t4.orElse(null), t5.orElse(null), t6.orElse(null))));

    public static InteractionResult reduce(InteractionResult first, InteractionResult second) {
        return second.m_19077_() && !first.m_19077_() || second.m_19080_() && !first.m_19080_() ? second : first;
    }

    public boolean appliesTo(Level level, InteractionHand hand, ItemStack stack) {
        return this.appliesTo(hand) && this.appliesTo(level, stack);
    }

    public boolean appliesTo(InteractionHand hand) {
        return this.hands().contains(hand);
    }

    public boolean appliesTo(Level level, ItemStack stack) {
        return ConfiguredItemCondition.check(this.itemCondition(), level, stack);
    }

    public void performActorItemStuff(LivingEntity actor, InteractionHand hand) {
        boolean modified;
        MutableObject heldStack = VariableAccess.hand(actor, hand);
        ConfiguredItemAction.execute(this.heldItemAction(), actor.f_19853_, heldStack);
        MutableObject resultingStack = this.itemResult() == null ? heldStack : new MutableObject((Object)this.itemResult().m_41777_());
        boolean bl = modified = this.itemResult() != null;
        if (this.resultItemAction() != null) {
            this.resultItemAction().execute(actor.f_19853_, (Mutable<ItemStack>)resultingStack);
            modified = true;
        }
        if (modified) {
            if (((ItemStack)heldStack.getValue()).m_41619_()) {
                actor.m_21008_(hand, (ItemStack)resultingStack.getValue());
            } else if (actor instanceof Player) {
                Player player = (Player)actor;
                player.m_150109_().m_150079_((ItemStack)resultingStack.getValue());
            }
        }
    }
}

