/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.configuration;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.ConditionData;
import io.github.edwinmindcraft.apoli.api.power.ConfiguredCondition;
import io.github.edwinmindcraft.apoli.api.power.ConfiguredFactory;
import io.github.edwinmindcraft.apoli.api.power.factory.BlockCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class ConfiguredBlockCondition<T extends IDynamicFeatureConfiguration, F extends BlockCondition<T>>
extends ConfiguredCondition<T, F> {
    public static final Codec<ConfiguredBlockCondition<?, ?>> CODEC = BlockCondition.CODEC.dispatch(ConfiguredFactory::getFactory, BlockCondition::getConditionCodec);
    public static final MapCodec<Optional<ConfiguredBlockCondition<?, ?>>> OPTIONAL_FIELD = CalioCodecHelper.optionalField(CODEC, "block_condition");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated(forRemoval=true)
    @Contract(value="null, _ -> true")
    @ApiStatus.ScheduledForRemoval(inVersion="1.19")
    public static boolean check(@Nullable ConfiguredBlockCondition<?, ?> condition, BlockInWorld block) {
        if (condition == null) return true;
        if (!condition.check(block.m_61175_(), block.m_61176_(), (NonNullSupplier<BlockState>)((NonNullSupplier)() -> ((BlockInWorld)block).m_61168_()))) return false;
        return true;
    }

    @Contract(value="null, _, _, _ -> true")
    public static boolean check(@Nullable ConfiguredBlockCondition<?, ?> condition, LevelReader reader, BlockPos position, NonNullSupplier<BlockState> state) {
        return condition == null || condition.check(reader, position, state);
    }

    @Contract(value="null, _, _ -> true")
    public static boolean check(@Nullable ConfiguredBlockCondition<?, ?> condition, LevelReader reader, BlockPos position) {
        return ConfiguredBlockCondition.check(condition, reader, position, (NonNullSupplier<BlockState>)((NonNullSupplier)() -> reader.m_8055_(position)));
    }

    public ConfiguredBlockCondition(F factory, T configuration, ConditionData data) {
        super(factory, configuration, data);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.19")
    public boolean check(BlockInWorld block) {
        return this.check(block.m_61175_(), block.m_61176_(), (NonNullSupplier<BlockState>)((NonNullSupplier)() -> ((BlockInWorld)block).m_61168_()));
    }

    public boolean check(LevelReader reader, BlockPos position, NonNullSupplier<BlockState> state) {
        return ((BlockCondition)this.getFactory()).check(this, reader, position, state);
    }

    public String toString() {
        return "CBC:" + ((BlockCondition)this.getFactory()).getRegistryName() + "(" + this.getData() + ")-" + this.getConfiguration();
    }
}

