/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public record PowerData(List<ConfiguredEntityCondition<?, ?>> conditions, boolean hidden, int loadingPriority, String name, String description) {
    public static final PowerData DEFAULT = new PowerData((List<ConfiguredEntityCondition<?, ?>>)ImmutableList.of(), false, 0, "", "");
    public static final MapCodec<PowerData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.listOf(ConfiguredEntityCondition.CODEC, "condition", "conditions").forGetter(PowerData::conditions), (App)CalioCodecHelper.optionalField(Codec.BOOL, "hidden", false).forGetter(PowerData::hidden), (App)CalioCodecHelper.optionalField(Codec.INT, "loading_priority", 0).forGetter(PowerData::loadingPriority), (App)CalioCodecHelper.optionalField(Codec.STRING, "name", "").forGetter(PowerData::name), (App)CalioCodecHelper.optionalField(Codec.STRING, "description", "").forGetter(PowerData::description)).apply((Applicative)instance, PowerData::new));

    public static Builder builder() {
        return new Builder();
    }

    public TranslatableComponent getName() {
        return new TranslatableComponent(this.name());
    }

    public TranslatableComponent getDescription() {
        return new TranslatableComponent(this.description());
    }

    public PowerData complete(ResourceLocation identifier) {
        return new PowerData(this.conditions, this.hidden, this.loadingPriority, (String)(StringUtils.isEmpty((CharSequence)this.name) ? "power." + identifier.m_135827_() + "." + identifier.m_135815_() + ".name" : this.name), (String)(StringUtils.isEmpty((CharSequence)this.description) ? "power." + identifier.m_135827_() + "." + identifier.m_135815_() + ".description" : this.description));
    }

    public Builder copyOf() {
        Builder builder = PowerData.builder().hidden(this.hidden).withPriority(this.loadingPriority).withName(this.name).withDescription(this.description);
        this.conditions.forEach(builder::addCondition);
        return builder;
    }

    public static class Builder {
        private final List<ConfiguredEntityCondition<?, ?>> conditions = new ArrayList();
        private boolean hidden = false;
        private int loadingPriority = 0;
        private String name = "";
        private String description = "";

        public List<ConfiguredEntityCondition<?, ?>> getConditions() {
            return this.conditions;
        }

        public Builder hidden() {
            this.hidden = true;
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder withPriority(int priority) {
            this.loadingPriority = priority;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withIdentifier(ResourceLocation identifier) {
            this.name = "power." + identifier.m_135827_() + "." + identifier.m_135815_() + ".name";
            this.description = "power." + identifier.m_135827_() + "." + identifier.m_135815_() + ".description";
            return this;
        }

        public Builder addCondition(ConfiguredEntityCondition<?, ?> condition) {
            this.conditions.add(condition);
            return this;
        }

        public PowerData build() {
            return new PowerData(this.conditions, this.hidden, this.loadingPriority, this.name, this.description);
        }
    }
}

