/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.configuration;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public record FieldConfiguration<T>(T value) implements IDynamicFeatureConfiguration
{
    public static <T> FieldConfiguration<T> of(T value) {
        return new FieldConfiguration<T>(value);
    }

    public static <T> Codec<FieldConfiguration<T>> codec(Codec<T> codec, String fieldName, T defaultValue) {
        return CalioCodecHelper.optionalField(codec, fieldName, defaultValue).xmap(FieldConfiguration::new, FieldConfiguration::value).codec();
    }

    public static <T> Codec<FieldConfiguration<T>> codec(MapCodec<T> codec) {
        return codec.xmap(FieldConfiguration::new, FieldConfiguration::value).codec();
    }

    public static <T> Codec<FieldConfiguration<T>> codec(Codec<T> codec, String fieldName) {
        return codec.fieldOf(fieldName).xmap(FieldConfiguration::new, FieldConfiguration::value).codec();
    }

    public static <T> Codec<FieldConfiguration<Optional<T>>> optionalCodec(Codec<T> codec, String fieldName) {
        return CalioCodecHelper.optionalField(codec, fieldName).xmap(FieldConfiguration::new, FieldConfiguration::value).codec();
    }

    @Override
    @NotNull
    public List<String> getErrors(@NotNull ICalioDynamicRegistryManager server) {
        T t = this.value();
        if (t instanceof IDynamicFeatureConfiguration) {
            IDynamicFeatureConfiguration config = (IDynamicFeatureConfiguration)t;
            return config.copyErrorsFrom(config, server, this.name(), new String[0]);
        }
        return ImmutableList.of();
    }

    @Override
    @NotNull
    public List<String> getWarnings(@NotNull ICalioDynamicRegistryManager server) {
        T t = this.value();
        if (t instanceof IDynamicFeatureConfiguration) {
            IDynamicFeatureConfiguration config = (IDynamicFeatureConfiguration)t;
            return config.copyWarningsFrom(config, server, this.name(), new String[0]);
        }
        return ImmutableList.of();
    }

    @Override
    public boolean isConfigurationValid() {
        IDynamicFeatureConfiguration config;
        T t = this.value();
        return !(t instanceof IDynamicFeatureConfiguration) || (config = (IDynamicFeatureConfiguration)t).isConfigurationValid();
    }
}

