/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api;

import com.mojang.serialization.Codec;
import io.github.edwinmindcraft.apoli.common.action.meta.ChanceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.ChoiceConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.DelayAction;
import io.github.edwinmindcraft.apoli.common.action.meta.IDelegatedActionConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IfElseConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.NothingConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.StreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.IDelegatedConditionConfiguration;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MetaFactories {
    public static <F extends IForgeRegistryEntry<F>, C, V> void defineMetaConditions(DeferredRegister<F> registry, Function<Codec<? extends IDelegatedConditionConfiguration<V>>, ? extends F> func, Codec<C> conditionCodec, BiPredicate<C, V> predicate) {
        registry.register("constant", () -> (IForgeRegistryEntry)func.apply(ConstantConfiguration.codec()));
        registry.register("and", () -> (IForgeRegistryEntry)func.apply(ConditionStreamConfiguration.andCodec(conditionCodec, predicate)));
        registry.register("or", () -> (IForgeRegistryEntry)func.apply(ConditionStreamConfiguration.orCodec(conditionCodec, predicate)));
    }

    public static <F extends IForgeRegistryEntry<F>, A, C, V> void defineMetaActions(DeferredRegister<F> registry, Function<Codec<? extends IDelegatedActionConfiguration<V>>, ? extends F> func, Codec<A> actionCodec, Codec<C> conditionCodec, BiConsumer<A, V> executor, BiPredicate<C, V> predicate) {
        registry.register("and", () -> (IForgeRegistryEntry)func.apply(StreamConfiguration.and(actionCodec, executor)));
        registry.register("chance", () -> (IForgeRegistryEntry)func.apply(ChanceConfiguration.codec(actionCodec, executor)));
        registry.register("if_else", () -> (IForgeRegistryEntry)func.apply(IfElseConfiguration.codec(conditionCodec, actionCodec, predicate, executor)));
        registry.register("if_else_list", () -> (IForgeRegistryEntry)func.apply(StreamConfiguration.ifElseList(conditionCodec, actionCodec, predicate, executor)));
        registry.register("choice", () -> (IForgeRegistryEntry)func.apply(ChoiceConfiguration.codec(actionCodec, executor)));
        registry.register("delay", () -> (IForgeRegistryEntry)func.apply(DelayAction.codec(actionCodec, executor)));
        registry.register("nothing", () -> (IForgeRegistryEntry)func.apply(NothingConfiguration.codec()));
    }
}

